%------------------------------------------------------------------------------
% File     : ITP145^2 : TPTP v9.2.0. Released v7.5.0.
% Domain   : Interactive Theorem Proving
% Problem  : Sledgehammer PHoareTotal problem prob_632__3264706_1
% Version  : Especial.
% English  :

% Refs     : [BH+15] Blanchette et al. (2015), Mining the Archive of Formal
%          : [Des21] Desharnais (2021), Email to Geoff Sutcliffe
% Source   : [Des21]
% Names    : PHoareTotal/prob_632__3264706_1 [Des21]

% Status   : Theorem
% Rating   : 0.67 v9.1.0, 0.33 v8.1.0, 0.75 v7.5.0
% Syntax   : Number of formulae    :  312 ( 113 unt;  48 typ;   0 def)
%            Number of atoms       :  641 ( 311 equ;   0 cnn)
%            Maximal formula atoms :    7 (   2 avg)
%            Number of connectives : 7312 ( 153   ~;  18   |;  67   &;6680   @)
%                                         (   0 <=>; 394  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   28 (  11 avg)
%            Number of types       :    4 (   3 usr)
%            Number of type conns  :  244 ( 244   >;   0   *;   0   +;   0  <<)
%            Number of symbols     :   46 (  45 usr;   4 con; 0-5 aty)
%            Number of variables   : 1353 (   6   ^;1262   !;  52   ?;1353   :)
%                                         (  33  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TH1_THM_EQU_NAR

% Comments : This file was generated by Sledgehammer 2021-02-23 16:19:50.622
%------------------------------------------------------------------------------
% Could-be-implicit typings (6)
thf(ty_t_Product__Type_Oprod,type,
    product_prod: $tType > $tType > $tType ).

thf(ty_t_PLang_Ostate,type,
    state: $tType ).

thf(ty_t_PLang_Ocom,type,
    com: $tType ).

thf(ty_t_List_Olist,type,
    list: $tType > $tType ).

thf(ty_t_Set_Oset,type,
    set: $tType > $tType ).

thf(ty_t_Nat_Onat,type,
    nat: $tType ).

% Explicit typings (42)
thf(sy_cl_HOL_Otype,type,
    type: 
      !>[A: $tType] : $o ).

thf(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : $o ).

thf(sy_cl_Orderings_Oord,type,
    ord: 
      !>[A: $tType] : $o ).

thf(sy_cl_Orderings_Olinorder,type,
    linorder: 
      !>[A: $tType] : $o ).

thf(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

thf(sy_c_List_Oappend,type,
    append: 
      !>[A: $tType] : ( ( list @ A ) > ( list @ A ) > ( list @ A ) ) ).

thf(sy_c_List_Obind,type,
    bind: 
      !>[A: $tType,B: $tType] : ( ( list @ A ) > ( A > ( list @ B ) ) > ( list @ B ) ) ).

thf(sy_c_List_Oconcat,type,
    concat: 
      !>[A: $tType] : ( ( list @ ( list @ A ) ) > ( list @ A ) ) ).

thf(sy_c_List_Ogen__length,type,
    gen_length: 
      !>[A: $tType] : ( nat > ( list @ A ) > nat ) ).

thf(sy_c_List_Oinsert,type,
    insert: 
      !>[A: $tType] : ( A > ( list @ A ) > ( list @ A ) ) ).

thf(sy_c_List_Olexord,type,
    lexord: 
      !>[A: $tType] : ( ( set @ ( product_prod @ A @ A ) ) > ( set @ ( product_prod @ ( list @ A ) @ ( list @ A ) ) ) ) ).

thf(sy_c_List_Olist_OCons,type,
    cons: 
      !>[A: $tType] : ( A > ( list @ A ) > ( list @ A ) ) ).

thf(sy_c_List_Olist_ONil,type,
    nil: 
      !>[A: $tType] : ( list @ A ) ).

thf(sy_c_List_Olistrel,type,
    listrel: 
      !>[A: $tType,B: $tType] : ( ( set @ ( product_prod @ A @ B ) ) > ( set @ ( product_prod @ ( list @ A ) @ ( list @ B ) ) ) ) ).

thf(sy_c_List_Olistrel1,type,
    listrel1: 
      !>[A: $tType] : ( ( set @ ( product_prod @ A @ A ) ) > ( set @ ( product_prod @ ( list @ A ) @ ( list @ A ) ) ) ) ).

thf(sy_c_List_Omaps,type,
    maps: 
      !>[A: $tType,B: $tType] : ( ( A > ( list @ B ) ) > ( list @ A ) > ( list @ B ) ) ).

thf(sy_c_List_On__lists,type,
    n_lists: 
      !>[A: $tType] : ( nat > ( list @ A ) > ( list @ ( list @ A ) ) ) ).

thf(sy_c_List_Onths,type,
    nths: 
      !>[A: $tType] : ( ( list @ A ) > ( set @ nat ) > ( list @ A ) ) ).

thf(sy_c_List_Oproduct__lists,type,
    product_lists: 
      !>[A: $tType] : ( ( list @ ( list @ A ) ) > ( list @ ( list @ A ) ) ) ).

thf(sy_c_List_Osubseqs,type,
    subseqs: 
      !>[A: $tType] : ( ( list @ A ) > ( list @ ( list @ A ) ) ) ).

thf(sy_c_Nat_OSuc,type,
    suc: nat > nat ).

thf(sy_c_PHoareTotal__Mirabelle__nfzgdgthbw_Oexec1,type,
    pHoare1053570893_exec1: set @ ( product_prod @ ( product_prod @ ( list @ com ) @ state ) @ ( product_prod @ ( list @ com ) @ state ) ) ).

thf(sy_c_PHoareTotal__Mirabelle__nfzgdgthbw_Oexecs,type,
    pHoare1053570959_execs: state > ( list @ com ) > state > $o ).

thf(sy_c_PHoareTotal__Mirabelle__nfzgdgthbw_Oinf,type,
    pHoare1838713294le_inf: ( list @ com ) > state > $o ).

thf(sy_c_PHoareTotal__Mirabelle__nfzgdgthbw_Otermis,type,
    pHoare1335526537termis: ( list @ com ) > state > $o ).

thf(sy_c_PLang_Ocom_OCond,type,
    cond: ( state > $o ) > com > com > com ).

thf(sy_c_PLang_Ocom_ODo,type,
    do: ( state > ( set @ state ) ) > com ).

thf(sy_c_PLang_Ocom_OSemi,type,
    semi: com > com > com ).

thf(sy_c_PLang_Ocom_OWhile,type,
    while: ( state > $o ) > com > com ).

thf(sy_c_PLang_Oexec,type,
    exec: state > com > state > $o ).

thf(sy_c_PTermi_Otermi,type,
    termi: com > state > $o ).

thf(sy_c_Product__Type_OPair,type,
    product_Pair: 
      !>[A: $tType,B: $tType] : ( A > B > ( product_prod @ A @ B ) ) ).

thf(sy_c_Product__Type_Oold_Oprod_Orec__prod,type,
    product_rec_prod: 
      !>[A: $tType,B: $tType,T: $tType] : ( ( A > B > T ) > ( product_prod @ A @ B ) > T ) ).

thf(sy_c_Relation_Oirrefl,type,
    irrefl: 
      !>[A: $tType] : ( ( set @ ( product_prod @ A @ A ) ) > $o ) ).

thf(sy_c_Set_OCollect,type,
    collect: 
      !>[A: $tType] : ( ( A > $o ) > ( set @ A ) ) ).

thf(sy_c_Transitive__Closure_Ortrancl,type,
    transitive_rtrancl: 
      !>[A: $tType] : ( ( set @ ( product_prod @ A @ A ) ) > ( set @ ( product_prod @ A @ A ) ) ) ).

thf(sy_c_Transitive__Closure_Otrancl,type,
    transitive_trancl: 
      !>[A: $tType] : ( ( set @ ( product_prod @ A @ A ) ) > ( set @ ( product_prod @ A @ A ) ) ) ).

thf(sy_c_member,type,
    member: 
      !>[A: $tType] : ( A > ( set @ A ) > $o ) ).

thf(sy_v_c,type,
    c: com ).

thf(sy_v_f,type,
    f: nat > ( product_prod @ ( list @ com ) @ state ) ).

thf(sy_v_n,type,
    n: nat ).

thf(sy_v_s,type,
    s: state ).

% Relevant facts (252)
thf(fact_0_exec1E_I1_J,axiom,
    ! [S: state,Cs: list @ com,S2: state] :
      ~ ( member @ ( product_prod @ ( product_prod @ ( list @ com ) @ state ) @ ( product_prod @ ( list @ com ) @ state ) ) @ ( product_Pair @ ( product_prod @ ( list @ com ) @ state ) @ ( product_prod @ ( list @ com ) @ state ) @ ( product_Pair @ ( list @ com ) @ state @ ( nil @ com ) @ S ) @ ( product_Pair @ ( list @ com ) @ state @ Cs @ S2 ) ) @ pHoare1053570893_exec1 ) ).

% exec1E(1)
thf(fact_1_renumber,axiom,
    ! [A: $tType,A2: A,F: nat > A,R: set @ ( product_prod @ A @ A )] :
      ( ! [I: nat] :
          ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ A2 @ ( F @ I ) ) @ ( transitive_rtrancl @ A @ R ) )
          & ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ ( F @ I ) @ ( F @ ( suc @ I ) ) ) @ R ) )
     => ? [F2: nat > A] :
          ( ( ( F2 @ ( zero_zero @ nat ) )
            = A2 )
          & ! [I2: nat] : ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ ( F2 @ I2 ) @ ( F2 @ ( suc @ I2 ) ) ) @ R ) ) ) ).

% renumber
thf(fact_2_renumber__aux,axiom,
    ! [A: $tType,A2: A,F: nat > A,R: set @ ( product_prod @ A @ A ),B2: A] :
      ( ! [I: nat] :
          ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ A2 @ ( F @ I ) ) @ ( transitive_rtrancl @ A @ R ) )
          & ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ ( F @ I ) @ ( F @ ( suc @ I ) ) ) @ R ) )
     => ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ A2 @ B2 ) @ ( transitive_rtrancl @ A @ R ) )
       => ( ( B2
            = ( F @ ( zero_zero @ nat ) ) )
         => ? [F2: nat > A] :
              ( ( ( F2 @ ( zero_zero @ nat ) )
                = A2 )
              & ! [I2: nat] : ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ ( F2 @ I2 ) @ ( F2 @ ( suc @ I2 ) ) ) @ R ) ) ) ) ) ).

% renumber_aux
thf(fact_3_execs__pres__termi,axiom,
    ! [C: com,S: state,C2: com,Cs: list @ com,S2: state] :
      ( ( member @ ( product_prod @ ( product_prod @ ( list @ com ) @ state ) @ ( product_prod @ ( list @ com ) @ state ) ) @ ( product_Pair @ ( product_prod @ ( list @ com ) @ state ) @ ( product_prod @ ( list @ com ) @ state ) @ ( product_Pair @ ( list @ com ) @ state @ ( cons @ com @ C @ ( nil @ com ) ) @ S ) @ ( product_Pair @ ( list @ com ) @ state @ ( cons @ com @ C2 @ Cs ) @ S2 ) ) @ ( transitive_rtrancl @ ( product_prod @ ( list @ com ) @ state ) @ pHoare1053570893_exec1 ) )
     => ( ( termi @ C @ S )
       => ( termi @ C2 @ S2 ) ) ) ).

% execs_pres_termi
thf(fact_4_rtrancl__trancl__absorb,axiom,
    ! [A: $tType,R2: set @ ( product_prod @ A @ A )] :
      ( ( transitive_trancl @ A @ ( transitive_rtrancl @ A @ R2 ) )
      = ( transitive_rtrancl @ A @ R2 ) ) ).

% rtrancl_trancl_absorb
thf(fact_5_trancl__rtrancl__absorb,axiom,
    ! [A: $tType,R2: set @ ( product_prod @ A @ A )] :
      ( ( transitive_rtrancl @ A @ ( transitive_trancl @ A @ R2 ) )
      = ( transitive_rtrancl @ A @ R2 ) ) ).

% trancl_rtrancl_absorb
thf(fact_6_trancl__induct2,axiom,
    ! [A: $tType,B: $tType,Ax: A,Ay: B,Bx: A,By: B,R: set @ ( product_prod @ ( product_prod @ A @ B ) @ ( product_prod @ A @ B ) ),P: A > B > $o] :
      ( ( member @ ( product_prod @ ( product_prod @ A @ B ) @ ( product_prod @ A @ B ) ) @ ( product_Pair @ ( product_prod @ A @ B ) @ ( product_prod @ A @ B ) @ ( product_Pair @ A @ B @ Ax @ Ay ) @ ( product_Pair @ A @ B @ Bx @ By ) ) @ ( transitive_trancl @ ( product_prod @ A @ B ) @ R ) )
     => ( ! [A3: A,B3: B] :
            ( ( member @ ( product_prod @ ( product_prod @ A @ B ) @ ( product_prod @ A @ B ) ) @ ( product_Pair @ ( product_prod @ A @ B ) @ ( product_prod @ A @ B ) @ ( product_Pair @ A @ B @ Ax @ Ay ) @ ( product_Pair @ A @ B @ A3 @ B3 ) ) @ R )
           => ( P @ A3 @ B3 ) )
       => ( ! [A3: A,B3: B,Aa: A,Ba: B] :
              ( ( member @ ( product_prod @ ( product_prod @ A @ B ) @ ( product_prod @ A @ B ) ) @ ( product_Pair @ ( product_prod @ A @ B ) @ ( product_prod @ A @ B ) @ ( product_Pair @ A @ B @ Ax @ Ay ) @ ( product_Pair @ A @ B @ A3 @ B3 ) ) @ ( transitive_trancl @ ( product_prod @ A @ B ) @ R ) )
             => ( ( member @ ( product_prod @ ( product_prod @ A @ B ) @ ( product_prod @ A @ B ) ) @ ( product_Pair @ ( product_prod @ A @ B ) @ ( product_prod @ A @ B ) @ ( product_Pair @ A @ B @ A3 @ B3 ) @ ( product_Pair @ A @ B @ Aa @ Ba ) ) @ R )
               => ( ( P @ A3 @ B3 )
                 => ( P @ Aa @ Ba ) ) ) )
         => ( P @ Bx @ By ) ) ) ) ).

% trancl_induct2
thf(fact_7_inf__def,axiom,
    ( pHoare1838713294le_inf
    = ( ^ [Cs2: list @ com,S3: state] :
        ? [F3: nat > ( product_prod @ ( list @ com ) @ state )] :
          ( ( ( F3 @ ( zero_zero @ nat ) )
            = ( product_Pair @ ( list @ com ) @ state @ Cs2 @ S3 ) )
          & ! [I3: nat] : ( member @ ( product_prod @ ( product_prod @ ( list @ com ) @ state ) @ ( product_prod @ ( list @ com ) @ state ) ) @ ( product_Pair @ ( product_prod @ ( list @ com ) @ state ) @ ( product_prod @ ( list @ com ) @ state ) @ ( F3 @ I3 ) @ ( F3 @ ( suc @ I3 ) ) ) @ pHoare1053570893_exec1 ) ) ) ) ).

% inf_def
thf(fact_8_rtrancl__induct2,axiom,
    ! [A: $tType,B: $tType,Ax: A,Ay: B,Bx: A,By: B,R: set @ ( product_prod @ ( product_prod @ A @ B ) @ ( product_prod @ A @ B ) ),P: A > B > $o] :
      ( ( member @ ( product_prod @ ( product_prod @ A @ B ) @ ( product_prod @ A @ B ) ) @ ( product_Pair @ ( product_prod @ A @ B ) @ ( product_prod @ A @ B ) @ ( product_Pair @ A @ B @ Ax @ Ay ) @ ( product_Pair @ A @ B @ Bx @ By ) ) @ ( transitive_rtrancl @ ( product_prod @ A @ B ) @ R ) )
     => ( ( P @ Ax @ Ay )
       => ( ! [A3: A,B3: B,Aa: A,Ba: B] :
              ( ( member @ ( product_prod @ ( product_prod @ A @ B ) @ ( product_prod @ A @ B ) ) @ ( product_Pair @ ( product_prod @ A @ B ) @ ( product_prod @ A @ B ) @ ( product_Pair @ A @ B @ Ax @ Ay ) @ ( product_Pair @ A @ B @ A3 @ B3 ) ) @ ( transitive_rtrancl @ ( product_prod @ A @ B ) @ R ) )
             => ( ( member @ ( product_prod @ ( product_prod @ A @ B ) @ ( product_prod @ A @ B ) ) @ ( product_Pair @ ( product_prod @ A @ B ) @ ( product_prod @ A @ B ) @ ( product_Pair @ A @ B @ A3 @ B3 ) @ ( product_Pair @ A @ B @ Aa @ Ba ) ) @ R )
               => ( ( P @ A3 @ B3 )
                 => ( P @ Aa @ Ba ) ) ) )
         => ( P @ Bx @ By ) ) ) ) ).

% rtrancl_induct2
thf(fact_9_converse__rtranclE2,axiom,
    ! [B: $tType,A: $tType,Xa: A,Xb: B,Za: A,Zb: B,R: set @ ( product_prod @ ( product_prod @ A @ B ) @ ( product_prod @ A @ B ) )] :
      ( ( member @ ( product_prod @ ( product_prod @ A @ B ) @ ( product_prod @ A @ B ) ) @ ( product_Pair @ ( product_prod @ A @ B ) @ ( product_prod @ A @ B ) @ ( product_Pair @ A @ B @ Xa @ Xb ) @ ( product_Pair @ A @ B @ Za @ Zb ) ) @ ( transitive_rtrancl @ ( product_prod @ A @ B ) @ R ) )
     => ( ( ( product_Pair @ A @ B @ Xa @ Xb )
         != ( product_Pair @ A @ B @ Za @ Zb ) )
       => ~ ! [A3: A,B3: B] :
              ( ( member @ ( product_prod @ ( product_prod @ A @ B ) @ ( product_prod @ A @ B ) ) @ ( product_Pair @ ( product_prod @ A @ B ) @ ( product_prod @ A @ B ) @ ( product_Pair @ A @ B @ Xa @ Xb ) @ ( product_Pair @ A @ B @ A3 @ B3 ) ) @ R )
             => ~ ( member @ ( product_prod @ ( product_prod @ A @ B ) @ ( product_prod @ A @ B ) ) @ ( product_Pair @ ( product_prod @ A @ B ) @ ( product_prod @ A @ B ) @ ( product_Pair @ A @ B @ A3 @ B3 ) @ ( product_Pair @ A @ B @ Za @ Zb ) ) @ ( transitive_rtrancl @ ( product_prod @ A @ B ) @ R ) ) ) ) ) ).

% converse_rtranclE2
thf(fact_10_converse__rtrancl__induct2,axiom,
    ! [A: $tType,B: $tType,Ax: A,Ay: B,Bx: A,By: B,R: set @ ( product_prod @ ( product_prod @ A @ B ) @ ( product_prod @ A @ B ) ),P: A > B > $o] :
      ( ( member @ ( product_prod @ ( product_prod @ A @ B ) @ ( product_prod @ A @ B ) ) @ ( product_Pair @ ( product_prod @ A @ B ) @ ( product_prod @ A @ B ) @ ( product_Pair @ A @ B @ Ax @ Ay ) @ ( product_Pair @ A @ B @ Bx @ By ) ) @ ( transitive_rtrancl @ ( product_prod @ A @ B ) @ R ) )
     => ( ( P @ Bx @ By )
       => ( ! [A3: A,B3: B,Aa: A,Ba: B] :
              ( ( member @ ( product_prod @ ( product_prod @ A @ B ) @ ( product_prod @ A @ B ) ) @ ( product_Pair @ ( product_prod @ A @ B ) @ ( product_prod @ A @ B ) @ ( product_Pair @ A @ B @ A3 @ B3 ) @ ( product_Pair @ A @ B @ Aa @ Ba ) ) @ R )
             => ( ( member @ ( product_prod @ ( product_prod @ A @ B ) @ ( product_prod @ A @ B ) ) @ ( product_Pair @ ( product_prod @ A @ B ) @ ( product_prod @ A @ B ) @ ( product_Pair @ A @ B @ Aa @ Ba ) @ ( product_Pair @ A @ B @ Bx @ By ) ) @ ( transitive_rtrancl @ ( product_prod @ A @ B ) @ R ) )
               => ( ( P @ Aa @ Ba )
                 => ( P @ A3 @ B3 ) ) ) )
         => ( P @ Ax @ Ay ) ) ) ) ).

% converse_rtrancl_induct2
thf(fact_11_tranclD,axiom,
    ! [A: $tType,X: A,Y: A,R2: set @ ( product_prod @ A @ A )] :
      ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ X @ Y ) @ ( transitive_trancl @ A @ R2 ) )
     => ? [Z: A] :
          ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ X @ Z ) @ R2 )
          & ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ Z @ Y ) @ ( transitive_rtrancl @ A @ R2 ) ) ) ) ).

% tranclD
thf(fact_12_rtranclD,axiom,
    ! [A: $tType,A2: A,B2: A,R2: set @ ( product_prod @ A @ A )] :
      ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ A2 @ B2 ) @ ( transitive_rtrancl @ A @ R2 ) )
     => ( ( A2 = B2 )
        | ( ( A2 != B2 )
          & ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ A2 @ B2 ) @ ( transitive_trancl @ A @ R2 ) ) ) ) ) ).

% rtranclD
thf(fact_13_tranclD2,axiom,
    ! [A: $tType,X: A,Y: A,R2: set @ ( product_prod @ A @ A )] :
      ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ X @ Y ) @ ( transitive_trancl @ A @ R2 ) )
     => ? [Z: A] :
          ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ X @ Z ) @ ( transitive_rtrancl @ A @ R2 ) )
          & ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ Z @ Y ) @ R2 ) ) ) ).

% tranclD2
thf(fact_14_trancl__into__rtrancl,axiom,
    ! [A: $tType,A2: A,B2: A,R: set @ ( product_prod @ A @ A )] :
      ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ A2 @ B2 ) @ ( transitive_trancl @ A @ R ) )
     => ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ A2 @ B2 ) @ ( transitive_rtrancl @ A @ R ) ) ) ).

% trancl_into_rtrancl
thf(fact_15_rtrancl__eq__or__trancl,axiom,
    ! [A: $tType,X: A,Y: A,R2: set @ ( product_prod @ A @ A )] :
      ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ X @ Y ) @ ( transitive_rtrancl @ A @ R2 ) )
      = ( ( X = Y )
        | ( ( X != Y )
          & ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ X @ Y ) @ ( transitive_trancl @ A @ R2 ) ) ) ) ) ).

% rtrancl_eq_or_trancl
thf(fact_16_r__into__rtrancl,axiom,
    ! [A: $tType,P2: product_prod @ A @ A,R: set @ ( product_prod @ A @ A )] :
      ( ( member @ ( product_prod @ A @ A ) @ P2 @ R )
     => ( member @ ( product_prod @ A @ A ) @ P2 @ ( transitive_rtrancl @ A @ R ) ) ) ).

% r_into_rtrancl
thf(fact_17_rtrancl__idemp,axiom,
    ! [A: $tType,R: set @ ( product_prod @ A @ A )] :
      ( ( transitive_rtrancl @ A @ ( transitive_rtrancl @ A @ R ) )
      = ( transitive_rtrancl @ A @ R ) ) ).

% rtrancl_idemp
thf(fact_18_r__into__trancl_H,axiom,
    ! [A: $tType,P2: product_prod @ A @ A,R: set @ ( product_prod @ A @ A )] :
      ( ( member @ ( product_prod @ A @ A ) @ P2 @ R )
     => ( member @ ( product_prod @ A @ A ) @ P2 @ ( transitive_trancl @ A @ R ) ) ) ).

% r_into_trancl'
thf(fact_19_converse__rtrancl__into__rtrancl,axiom,
    ! [A: $tType,A2: A,B2: A,R: set @ ( product_prod @ A @ A ),C: A] :
      ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ A2 @ B2 ) @ R )
     => ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ B2 @ C ) @ ( transitive_rtrancl @ A @ R ) )
       => ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ A2 @ C ) @ ( transitive_rtrancl @ A @ R ) ) ) ) ).

% converse_rtrancl_into_rtrancl
thf(fact_20_rtrancl_Ortrancl__into__rtrancl,axiom,
    ! [A: $tType,A2: A,B2: A,R: set @ ( product_prod @ A @ A ),C: A] :
      ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ A2 @ B2 ) @ ( transitive_rtrancl @ A @ R ) )
     => ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ B2 @ C ) @ R )
       => ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ A2 @ C ) @ ( transitive_rtrancl @ A @ R ) ) ) ) ).

% rtrancl.rtrancl_into_rtrancl
thf(fact_21_converse__rtrancl__induct,axiom,
    ! [A: $tType,A2: A,B2: A,R: set @ ( product_prod @ A @ A ),P: A > $o] :
      ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ A2 @ B2 ) @ ( transitive_rtrancl @ A @ R ) )
     => ( ( P @ B2 )
       => ( ! [Y2: A,Z: A] :
              ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ Y2 @ Z ) @ R )
             => ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ Z @ B2 ) @ ( transitive_rtrancl @ A @ R ) )
               => ( ( P @ Z )
                 => ( P @ Y2 ) ) ) )
         => ( P @ A2 ) ) ) ) ).

% converse_rtrancl_induct
thf(fact_22_rtrancl_Ortrancl__refl,axiom,
    ! [A: $tType,A2: A,R: set @ ( product_prod @ A @ A )] : ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ A2 @ A2 ) @ ( transitive_rtrancl @ A @ R ) ) ).

% rtrancl.rtrancl_refl
thf(fact_23_converse__rtranclE,axiom,
    ! [A: $tType,X: A,Z2: A,R: set @ ( product_prod @ A @ A )] :
      ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ X @ Z2 ) @ ( transitive_rtrancl @ A @ R ) )
     => ( ( X != Z2 )
       => ~ ! [Y2: A] :
              ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ X @ Y2 ) @ R )
             => ~ ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ Y2 @ Z2 ) @ ( transitive_rtrancl @ A @ R ) ) ) ) ) ).

% converse_rtranclE
thf(fact_24_rtrancl_Oinducts,axiom,
    ! [A: $tType,X1: A,X2: A,R: set @ ( product_prod @ A @ A ),P: A > A > $o] :
      ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ X1 @ X2 ) @ ( transitive_rtrancl @ A @ R ) )
     => ( ! [A3: A] : ( P @ A3 @ A3 )
       => ( ! [A3: A,B3: A,C3: A] :
              ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ A3 @ B3 ) @ ( transitive_rtrancl @ A @ R ) )
             => ( ( P @ A3 @ B3 )
               => ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ B3 @ C3 ) @ R )
                 => ( P @ A3 @ C3 ) ) ) )
         => ( P @ X1 @ X2 ) ) ) ) ).

% rtrancl.inducts
thf(fact_25_rtrancl__induct,axiom,
    ! [A: $tType,A2: A,B2: A,R: set @ ( product_prod @ A @ A ),P: A > $o] :
      ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ A2 @ B2 ) @ ( transitive_rtrancl @ A @ R ) )
     => ( ( P @ A2 )
       => ( ! [Y2: A,Z: A] :
              ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ A2 @ Y2 ) @ ( transitive_rtrancl @ A @ R ) )
             => ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ Y2 @ Z ) @ R )
               => ( ( P @ Y2 )
                 => ( P @ Z ) ) ) )
         => ( P @ B2 ) ) ) ) ).

% rtrancl_induct
thf(fact_26_rtrancl__trans,axiom,
    ! [A: $tType,X: A,Y: A,R: set @ ( product_prod @ A @ A ),Z2: A] :
      ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ X @ Y ) @ ( transitive_rtrancl @ A @ R ) )
     => ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ Y @ Z2 ) @ ( transitive_rtrancl @ A @ R ) )
       => ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ X @ Z2 ) @ ( transitive_rtrancl @ A @ R ) ) ) ) ).

% rtrancl_trans
thf(fact_27_rtrancl_Osimps,axiom,
    ! [A: $tType,A1: A,A22: A,R: set @ ( product_prod @ A @ A )] :
      ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ A1 @ A22 ) @ ( transitive_rtrancl @ A @ R ) )
      = ( ? [A4: A] :
            ( ( A1 = A4 )
            & ( A22 = A4 ) )
        | ? [A4: A,B4: A,C4: A] :
            ( ( A1 = A4 )
            & ( A22 = C4 )
            & ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ A4 @ B4 ) @ ( transitive_rtrancl @ A @ R ) )
            & ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ B4 @ C4 ) @ R ) ) ) ) ).

% rtrancl.simps
thf(fact_28_rtrancl_Ocases,axiom,
    ! [A: $tType,A1: A,A22: A,R: set @ ( product_prod @ A @ A )] :
      ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ A1 @ A22 ) @ ( transitive_rtrancl @ A @ R ) )
     => ( ( A22 != A1 )
       => ~ ! [B3: A] :
              ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ A1 @ B3 ) @ ( transitive_rtrancl @ A @ R ) )
             => ~ ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ B3 @ A22 ) @ R ) ) ) ) ).

% rtrancl.cases
thf(fact_29_rtranclE,axiom,
    ! [A: $tType,A2: A,B2: A,R: set @ ( product_prod @ A @ A )] :
      ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ A2 @ B2 ) @ ( transitive_rtrancl @ A @ R ) )
     => ( ( A2 != B2 )
       => ~ ! [Y2: A] :
              ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ A2 @ Y2 ) @ ( transitive_rtrancl @ A @ R ) )
             => ~ ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ Y2 @ B2 ) @ R ) ) ) ) ).

% rtranclE
thf(fact_30_trancl_Otrancl__into__trancl,axiom,
    ! [A: $tType,A2: A,B2: A,R: set @ ( product_prod @ A @ A ),C: A] :
      ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ A2 @ B2 ) @ ( transitive_trancl @ A @ R ) )
     => ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ B2 @ C ) @ R )
       => ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ A2 @ C ) @ ( transitive_trancl @ A @ R ) ) ) ) ).

% trancl.trancl_into_trancl
thf(fact_31_converse__trancl__induct,axiom,
    ! [A: $tType,A2: A,B2: A,R: set @ ( product_prod @ A @ A ),P: A > $o] :
      ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ A2 @ B2 ) @ ( transitive_trancl @ A @ R ) )
     => ( ! [Y2: A] :
            ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ Y2 @ B2 ) @ R )
           => ( P @ Y2 ) )
       => ( ! [Y2: A,Z: A] :
              ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ Y2 @ Z ) @ R )
             => ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ Z @ B2 ) @ ( transitive_trancl @ A @ R ) )
               => ( ( P @ Z )
                 => ( P @ Y2 ) ) ) )
         => ( P @ A2 ) ) ) ) ).

% converse_trancl_induct
thf(fact_32_trancl_Or__into__trancl,axiom,
    ! [A: $tType,A2: A,B2: A,R: set @ ( product_prod @ A @ A )] :
      ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ A2 @ B2 ) @ R )
     => ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ A2 @ B2 ) @ ( transitive_trancl @ A @ R ) ) ) ).

% trancl.r_into_trancl
thf(fact_33_trancl__trans__induct,axiom,
    ! [A: $tType,X: A,Y: A,R: set @ ( product_prod @ A @ A ),P: A > A > $o] :
      ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ X @ Y ) @ ( transitive_trancl @ A @ R ) )
     => ( ! [X3: A,Y2: A] :
            ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ X3 @ Y2 ) @ R )
           => ( P @ X3 @ Y2 ) )
       => ( ! [X3: A,Y2: A,Z: A] :
              ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ X3 @ Y2 ) @ ( transitive_trancl @ A @ R ) )
             => ( ( P @ X3 @ Y2 )
               => ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ Y2 @ Z ) @ ( transitive_trancl @ A @ R ) )
                 => ( ( P @ Y2 @ Z )
                   => ( P @ X3 @ Z ) ) ) ) )
         => ( P @ X @ Y ) ) ) ) ).

% trancl_trans_induct
thf(fact_34_trancl__into__trancl2,axiom,
    ! [A: $tType,A2: A,B2: A,R: set @ ( product_prod @ A @ A ),C: A] :
      ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ A2 @ B2 ) @ R )
     => ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ B2 @ C ) @ ( transitive_trancl @ A @ R ) )
       => ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ A2 @ C ) @ ( transitive_trancl @ A @ R ) ) ) ) ).

% trancl_into_trancl2
thf(fact_35_irrefl__trancl__rD,axiom,
    ! [A: $tType,R: set @ ( product_prod @ A @ A ),X: A,Y: A] :
      ( ! [X3: A] :
          ~ ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ X3 @ X3 ) @ ( transitive_trancl @ A @ R ) )
     => ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ X @ Y ) @ R )
       => ( X != Y ) ) ) ).

% irrefl_trancl_rD
thf(fact_36_converse__tranclE,axiom,
    ! [A: $tType,X: A,Z2: A,R: set @ ( product_prod @ A @ A )] :
      ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ X @ Z2 ) @ ( transitive_trancl @ A @ R ) )
     => ( ~ ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ X @ Z2 ) @ R )
       => ~ ! [Y2: A] :
              ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ X @ Y2 ) @ R )
             => ~ ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ Y2 @ Z2 ) @ ( transitive_trancl @ A @ R ) ) ) ) ) ).

% converse_tranclE
thf(fact_37_r__r__into__trancl,axiom,
    ! [A: $tType,A2: A,B2: A,R2: set @ ( product_prod @ A @ A ),C: A] :
      ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ A2 @ B2 ) @ R2 )
     => ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ B2 @ C ) @ R2 )
       => ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ A2 @ C ) @ ( transitive_trancl @ A @ R2 ) ) ) ) ).

% r_r_into_trancl
thf(fact_38_trancl_Oinducts,axiom,
    ! [A: $tType,X1: A,X2: A,R: set @ ( product_prod @ A @ A ),P: A > A > $o] :
      ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ X1 @ X2 ) @ ( transitive_trancl @ A @ R ) )
     => ( ! [A3: A,B3: A] :
            ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ A3 @ B3 ) @ R )
           => ( P @ A3 @ B3 ) )
       => ( ! [A3: A,B3: A,C3: A] :
              ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ A3 @ B3 ) @ ( transitive_trancl @ A @ R ) )
             => ( ( P @ A3 @ B3 )
               => ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ B3 @ C3 ) @ R )
                 => ( P @ A3 @ C3 ) ) ) )
         => ( P @ X1 @ X2 ) ) ) ) ).

% trancl.inducts
thf(fact_39_trancl__induct,axiom,
    ! [A: $tType,A2: A,B2: A,R: set @ ( product_prod @ A @ A ),P: A > $o] :
      ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ A2 @ B2 ) @ ( transitive_trancl @ A @ R ) )
     => ( ! [Y2: A] :
            ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ A2 @ Y2 ) @ R )
           => ( P @ Y2 ) )
       => ( ! [Y2: A,Z: A] :
              ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ A2 @ Y2 ) @ ( transitive_trancl @ A @ R ) )
             => ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ Y2 @ Z ) @ R )
               => ( ( P @ Y2 )
                 => ( P @ Z ) ) ) )
         => ( P @ B2 ) ) ) ) ).

% trancl_induct
thf(fact_40_trancl__trans,axiom,
    ! [A: $tType,X: A,Y: A,R: set @ ( product_prod @ A @ A ),Z2: A] :
      ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ X @ Y ) @ ( transitive_trancl @ A @ R ) )
     => ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ Y @ Z2 ) @ ( transitive_trancl @ A @ R ) )
       => ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ X @ Z2 ) @ ( transitive_trancl @ A @ R ) ) ) ) ).

% trancl_trans
thf(fact_41_trancl_Osimps,axiom,
    ! [A: $tType,A1: A,A22: A,R: set @ ( product_prod @ A @ A )] :
      ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ A1 @ A22 ) @ ( transitive_trancl @ A @ R ) )
      = ( ? [A4: A,B4: A] :
            ( ( A1 = A4 )
            & ( A22 = B4 )
            & ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ A4 @ B4 ) @ R ) )
        | ? [A4: A,B4: A,C4: A] :
            ( ( A1 = A4 )
            & ( A22 = C4 )
            & ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ A4 @ B4 ) @ ( transitive_trancl @ A @ R ) )
            & ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ B4 @ C4 ) @ R ) ) ) ) ).

% trancl.simps
thf(fact_42_trancl_Ocases,axiom,
    ! [A: $tType,A1: A,A22: A,R: set @ ( product_prod @ A @ A )] :
      ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ A1 @ A22 ) @ ( transitive_trancl @ A @ R ) )
     => ( ~ ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ A1 @ A22 ) @ R )
       => ~ ! [B3: A] :
              ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ A1 @ B3 ) @ ( transitive_trancl @ A @ R ) )
             => ~ ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ B3 @ A22 ) @ R ) ) ) ) ).

% trancl.cases
thf(fact_43_tranclE,axiom,
    ! [A: $tType,A2: A,B2: A,R: set @ ( product_prod @ A @ A )] :
      ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ A2 @ B2 ) @ ( transitive_trancl @ A @ R ) )
     => ( ~ ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ A2 @ B2 ) @ R )
       => ~ ! [C3: A] :
              ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ A2 @ C3 ) @ ( transitive_trancl @ A @ R ) )
             => ~ ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ C3 @ B2 ) @ R ) ) ) ) ).

% tranclE
thf(fact_44_termi__impl__not__inf,axiom,
    ! [C: com,S: state] :
      ( ( termi @ C @ S )
     => ~ ( pHoare1838713294le_inf @ ( cons @ com @ C @ ( nil @ com ) ) @ S ) ) ).

% termi_impl_not_inf
thf(fact_45_mem__Collect__eq,axiom,
    ! [A: $tType,A2: A,P: A > $o] :
      ( ( member @ A @ A2 @ ( collect @ A @ P ) )
      = ( P @ A2 ) ) ).

% mem_Collect_eq
thf(fact_46_Collect__mem__eq,axiom,
    ! [A: $tType,A5: set @ A] :
      ( ( collect @ A
        @ ^ [X4: A] : ( member @ A @ X4 @ A5 ) )
      = A5 ) ).

% Collect_mem_eq
thf(fact_47_Collect__cong,axiom,
    ! [A: $tType,P: A > $o,Q: A > $o] :
      ( ! [X3: A] :
          ( ( P @ X3 )
          = ( Q @ X3 ) )
     => ( ( collect @ A @ P )
        = ( collect @ A @ Q ) ) ) ).

% Collect_cong
thf(fact_48_trancl__rtrancl__trancl,axiom,
    ! [A: $tType,A2: A,B2: A,R: set @ ( product_prod @ A @ A ),C: A] :
      ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ A2 @ B2 ) @ ( transitive_trancl @ A @ R ) )
     => ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ B2 @ C ) @ ( transitive_rtrancl @ A @ R ) )
       => ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ A2 @ C ) @ ( transitive_trancl @ A @ R ) ) ) ) ).

% trancl_rtrancl_trancl
thf(fact_49_rtrancl__trancl__trancl,axiom,
    ! [A: $tType,X: A,Y: A,R: set @ ( product_prod @ A @ A ),Z2: A] :
      ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ X @ Y ) @ ( transitive_rtrancl @ A @ R ) )
     => ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ Y @ Z2 ) @ ( transitive_trancl @ A @ R ) )
       => ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ X @ Z2 ) @ ( transitive_trancl @ A @ R ) ) ) ) ).

% rtrancl_trancl_trancl
thf(fact_50_rtrancl__into__trancl2,axiom,
    ! [A: $tType,A2: A,B2: A,R: set @ ( product_prod @ A @ A ),C: A] :
      ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ A2 @ B2 ) @ R )
     => ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ B2 @ C ) @ ( transitive_rtrancl @ A @ R ) )
       => ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ A2 @ C ) @ ( transitive_trancl @ A @ R ) ) ) ) ).

% rtrancl_into_trancl2
thf(fact_51_rtrancl__into__trancl1,axiom,
    ! [A: $tType,A2: A,B2: A,R: set @ ( product_prod @ A @ A ),C: A] :
      ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ A2 @ B2 ) @ ( transitive_rtrancl @ A @ R ) )
     => ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ B2 @ C ) @ R )
       => ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ A2 @ C ) @ ( transitive_trancl @ A @ R ) ) ) ) ).

% rtrancl_into_trancl1
thf(fact_52_exec1s__impl__execs,axiom,
    ! [Cs3: list @ com,S: state,T2: state] :
      ( ( member @ ( product_prod @ ( product_prod @ ( list @ com ) @ state ) @ ( product_prod @ ( list @ com ) @ state ) ) @ ( product_Pair @ ( product_prod @ ( list @ com ) @ state ) @ ( product_prod @ ( list @ com ) @ state ) @ ( product_Pair @ ( list @ com ) @ state @ Cs3 @ S ) @ ( product_Pair @ ( list @ com ) @ state @ ( nil @ com ) @ T2 ) ) @ ( transitive_rtrancl @ ( product_prod @ ( list @ com ) @ state ) @ pHoare1053570893_exec1 ) )
     => ( pHoare1053570959_execs @ S @ Cs3 @ T2 ) ) ).

% exec1s_impl_execs
thf(fact_53_execs__pres__termis,axiom,
    ! [Cs3: list @ com,S: state,Cs: list @ com,S2: state] :
      ( ( member @ ( product_prod @ ( product_prod @ ( list @ com ) @ state ) @ ( product_prod @ ( list @ com ) @ state ) ) @ ( product_Pair @ ( product_prod @ ( list @ com ) @ state ) @ ( product_prod @ ( list @ com ) @ state ) @ ( product_Pair @ ( list @ com ) @ state @ Cs3 @ S ) @ ( product_Pair @ ( list @ com ) @ state @ Cs @ S2 ) ) @ ( transitive_rtrancl @ ( product_prod @ ( list @ com ) @ state ) @ pHoare1053570893_exec1 ) )
     => ( ( pHoare1335526537termis @ Cs3 @ S )
       => ( pHoare1335526537termis @ Cs @ S2 ) ) ) ).

% execs_pres_termis
thf(fact_54_old_Onat_Oinject,axiom,
    ! [Nat: nat,Nat2: nat] :
      ( ( ( suc @ Nat )
        = ( suc @ Nat2 ) )
      = ( Nat = Nat2 ) ) ).

% old.nat.inject
thf(fact_55_nat_Oinject,axiom,
    ! [X2: nat,Y22: nat] :
      ( ( ( suc @ X2 )
        = ( suc @ Y22 ) )
      = ( X2 = Y22 ) ) ).

% nat.inject
thf(fact_56_list_Oinject,axiom,
    ! [A: $tType,X21: A,X22: list @ A,Y21: A,Y222: list @ A] :
      ( ( ( cons @ A @ X21 @ X22 )
        = ( cons @ A @ Y21 @ Y222 ) )
      = ( ( X21 = Y21 )
        & ( X22 = Y222 ) ) ) ).

% list.inject
thf(fact_57_exec1s__impl__exec,axiom,
    ! [C: com,S: state,T2: state] :
      ( ( member @ ( product_prod @ ( product_prod @ ( list @ com ) @ state ) @ ( product_prod @ ( list @ com ) @ state ) ) @ ( product_Pair @ ( product_prod @ ( list @ com ) @ state ) @ ( product_prod @ ( list @ com ) @ state ) @ ( product_Pair @ ( list @ com ) @ state @ ( cons @ com @ C @ ( nil @ com ) ) @ S ) @ ( product_Pair @ ( list @ com ) @ state @ ( nil @ com ) @ T2 ) ) @ ( transitive_rtrancl @ ( product_prod @ ( list @ com ) @ state ) @ pHoare1053570893_exec1 ) )
     => ( exec @ S @ C @ T2 ) ) ).

% exec1s_impl_exec
thf(fact_58_old_Oprod_Oinject,axiom,
    ! [A: $tType,B: $tType,A2: A,B2: B,A6: A,B5: B] :
      ( ( ( product_Pair @ A @ B @ A2 @ B2 )
        = ( product_Pair @ A @ B @ A6 @ B5 ) )
      = ( ( A2 = A6 )
        & ( B2 = B5 ) ) ) ).

% old.prod.inject
thf(fact_59_prod_Oinject,axiom,
    ! [A: $tType,B: $tType,X1: A,X2: B,Y1: A,Y22: B] :
      ( ( ( product_Pair @ A @ B @ X1 @ X2 )
        = ( product_Pair @ A @ B @ Y1 @ Y22 ) )
      = ( ( X1 = Y1 )
        & ( X2 = Y22 ) ) ) ).

% prod.inject
thf(fact_60_execs_Ointros_I2_J,axiom,
    ! [S: state,C: com,T2: state,Cs3: list @ com,U: state] :
      ( ( exec @ S @ C @ T2 )
     => ( ( pHoare1053570959_execs @ T2 @ Cs3 @ U )
       => ( pHoare1053570959_execs @ S @ ( cons @ com @ C @ Cs3 ) @ U ) ) ) ).

% execs.intros(2)
thf(fact_61_execs_Ocases,axiom,
    ! [A1: state,A22: list @ com,A32: state] :
      ( ( pHoare1053570959_execs @ A1 @ A22 @ A32 )
     => ( ( ( A22
            = ( nil @ com ) )
         => ( A32 != A1 ) )
       => ~ ! [C3: com,T3: state,Cs4: list @ com] :
              ( ( A22
                = ( cons @ com @ C3 @ Cs4 ) )
             => ( ( exec @ A1 @ C3 @ T3 )
               => ~ ( pHoare1053570959_execs @ T3 @ Cs4 @ A32 ) ) ) ) ) ).

% execs.cases
thf(fact_62_execs_Osimps,axiom,
    ( pHoare1053570959_execs
    = ( ^ [A12: state,A23: list @ com,A33: state] :
          ( ? [S3: state] :
              ( ( A12 = S3 )
              & ( A23
                = ( nil @ com ) )
              & ( A33 = S3 ) )
          | ? [S3: state,C4: com,T4: state,Cs2: list @ com,U2: state] :
              ( ( A12 = S3 )
              & ( A23
                = ( cons @ com @ C4 @ Cs2 ) )
              & ( A33 = U2 )
              & ( exec @ S3 @ C4 @ T4 )
              & ( pHoare1053570959_execs @ T4 @ Cs2 @ U2 ) ) ) ) ) ).

% execs.simps
thf(fact_63_execs_Oinducts,axiom,
    ! [X1: state,X2: list @ com,X32: state,P: state > ( list @ com ) > state > $o] :
      ( ( pHoare1053570959_execs @ X1 @ X2 @ X32 )
     => ( ! [S4: state] : ( P @ S4 @ ( nil @ com ) @ S4 )
       => ( ! [S4: state,C3: com,T3: state,Cs4: list @ com,U3: state] :
              ( ( exec @ S4 @ C3 @ T3 )
             => ( ( pHoare1053570959_execs @ T3 @ Cs4 @ U3 )
               => ( ( P @ T3 @ Cs4 @ U3 )
                 => ( P @ S4 @ ( cons @ com @ C3 @ Cs4 ) @ U3 ) ) ) )
         => ( P @ X1 @ X2 @ X32 ) ) ) ) ).

% execs.inducts
thf(fact_64_termis_Osimps_I2_J,axiom,
    ! [C: com,Cs3: list @ com,S: state] :
      ( ( pHoare1335526537termis @ ( cons @ com @ C @ Cs3 ) @ S )
      = ( ( termi @ C @ S )
        & ! [T4: state] :
            ( ( exec @ S @ C @ T4 )
           => ( pHoare1335526537termis @ Cs3 @ T4 ) ) ) ) ).

% termis.simps(2)
thf(fact_65_execs_Ointros_I1_J,axiom,
    ! [S: state] : ( pHoare1053570959_execs @ S @ ( nil @ com ) @ S ) ).

% execs.intros(1)
thf(fact_66_termis_Osimps_I1_J,axiom,
    ! [S: state] : ( pHoare1335526537termis @ ( nil @ com ) @ S ) ).

% termis.simps(1)
thf(fact_67_zero__reorient,axiom,
    ! [A: $tType] :
      ( ( zero @ A )
     => ! [X: A] :
          ( ( ( zero_zero @ A )
            = X )
          = ( X
            = ( zero_zero @ A ) ) ) ) ).

% zero_reorient
thf(fact_68_surj__pair,axiom,
    ! [A: $tType,B: $tType,P2: product_prod @ A @ B] :
    ? [X3: A,Y2: B] :
      ( P2
      = ( product_Pair @ A @ B @ X3 @ Y2 ) ) ).

% surj_pair
thf(fact_69_prod__cases,axiom,
    ! [B: $tType,A: $tType,P: ( product_prod @ A @ B ) > $o,P2: product_prod @ A @ B] :
      ( ! [A3: A,B3: B] : ( P @ ( product_Pair @ A @ B @ A3 @ B3 ) )
     => ( P @ P2 ) ) ).

% prod_cases
thf(fact_70_Pair__inject,axiom,
    ! [A: $tType,B: $tType,A2: A,B2: B,A6: A,B5: B] :
      ( ( ( product_Pair @ A @ B @ A2 @ B2 )
        = ( product_Pair @ A @ B @ A6 @ B5 ) )
     => ~ ( ( A2 = A6 )
         => ( B2 != B5 ) ) ) ).

% Pair_inject
thf(fact_71_old_Oprod_Oexhaust,axiom,
    ! [A: $tType,B: $tType,Y: product_prod @ A @ B] :
      ~ ! [A3: A,B3: B] :
          ( Y
         != ( product_Pair @ A @ B @ A3 @ B3 ) ) ).

% old.prod.exhaust
thf(fact_72_old_Oprod_Oinducts,axiom,
    ! [B: $tType,A: $tType,P: ( product_prod @ A @ B ) > $o,Prod: product_prod @ A @ B] :
      ( ! [A3: A,B3: B] : ( P @ ( product_Pair @ A @ B @ A3 @ B3 ) )
     => ( P @ Prod ) ) ).

% old.prod.inducts
thf(fact_73_not__Cons__self2,axiom,
    ! [A: $tType,X: A,Xs: list @ A] :
      ( ( cons @ A @ X @ Xs )
     != Xs ) ).

% not_Cons_self2
thf(fact_74_Suc__inject,axiom,
    ! [X: nat,Y: nat] :
      ( ( ( suc @ X )
        = ( suc @ Y ) )
     => ( X = Y ) ) ).

% Suc_inject
thf(fact_75_n__not__Suc__n,axiom,
    ! [N: nat] :
      ( N
     != ( suc @ N ) ) ).

% n_not_Suc_n
thf(fact_76_inf__cases,axiom,
    ! [C: com,Cs3: list @ com,S: state] :
      ( ( pHoare1838713294le_inf @ ( cons @ com @ C @ Cs3 ) @ S )
     => ( ( pHoare1838713294le_inf @ ( cons @ com @ C @ ( nil @ com ) ) @ S )
        | ? [T3: state] :
            ( ( exec @ S @ C @ T3 )
            & ( pHoare1838713294le_inf @ Cs3 @ T3 ) ) ) ) ).

% inf_cases
thf(fact_77_nat_Odistinct_I1_J,axiom,
    ! [X2: nat] :
      ( ( zero_zero @ nat )
     != ( suc @ X2 ) ) ).

% nat.distinct(1)
thf(fact_78_old_Onat_Odistinct_I2_J,axiom,
    ! [Nat3: nat] :
      ( ( suc @ Nat3 )
     != ( zero_zero @ nat ) ) ).

% old.nat.distinct(2)
thf(fact_79_old_Onat_Odistinct_I1_J,axiom,
    ! [Nat2: nat] :
      ( ( zero_zero @ nat )
     != ( suc @ Nat2 ) ) ).

% old.nat.distinct(1)
thf(fact_80_nat_OdiscI,axiom,
    ! [Nat: nat,X2: nat] :
      ( ( Nat
        = ( suc @ X2 ) )
     => ( Nat
       != ( zero_zero @ nat ) ) ) ).

% nat.discI
thf(fact_81_nat__induct,axiom,
    ! [P: nat > $o,N: nat] :
      ( ( P @ ( zero_zero @ nat ) )
     => ( ! [N2: nat] :
            ( ( P @ N2 )
           => ( P @ ( suc @ N2 ) ) )
       => ( P @ N ) ) ) ).

% nat_induct
thf(fact_82_diff__induct,axiom,
    ! [P: nat > nat > $o,M: nat,N: nat] :
      ( ! [X3: nat] : ( P @ X3 @ ( zero_zero @ nat ) )
     => ( ! [Y2: nat] : ( P @ ( zero_zero @ nat ) @ ( suc @ Y2 ) )
       => ( ! [X3: nat,Y2: nat] :
              ( ( P @ X3 @ Y2 )
             => ( P @ ( suc @ X3 ) @ ( suc @ Y2 ) ) )
         => ( P @ M @ N ) ) ) ) ).

% diff_induct
thf(fact_83_zero__induct,axiom,
    ! [P: nat > $o,K: nat] :
      ( ( P @ K )
     => ( ! [N2: nat] :
            ( ( P @ ( suc @ N2 ) )
           => ( P @ N2 ) )
       => ( P @ ( zero_zero @ nat ) ) ) ) ).

% zero_induct
thf(fact_84_Suc__neq__Zero,axiom,
    ! [M: nat] :
      ( ( suc @ M )
     != ( zero_zero @ nat ) ) ).

% Suc_neq_Zero
thf(fact_85_Zero__neq__Suc,axiom,
    ! [M: nat] :
      ( ( zero_zero @ nat )
     != ( suc @ M ) ) ).

% Zero_neq_Suc
thf(fact_86_Zero__not__Suc,axiom,
    ! [M: nat] :
      ( ( zero_zero @ nat )
     != ( suc @ M ) ) ).

% Zero_not_Suc
thf(fact_87_old_Onat_Oexhaust,axiom,
    ! [Y: nat] :
      ( ( Y
       != ( zero_zero @ nat ) )
     => ~ ! [Nat4: nat] :
            ( Y
           != ( suc @ Nat4 ) ) ) ).

% old.nat.exhaust
thf(fact_88_old_Onat_Oinducts,axiom,
    ! [P: nat > $o,Nat: nat] :
      ( ( P @ ( zero_zero @ nat ) )
     => ( ! [Nat4: nat] :
            ( ( P @ Nat4 )
           => ( P @ ( suc @ Nat4 ) ) )
       => ( P @ Nat ) ) ) ).

% old.nat.inducts
thf(fact_89_not0__implies__Suc,axiom,
    ! [N: nat] :
      ( ( N
       != ( zero_zero @ nat ) )
     => ? [M2: nat] :
          ( N
          = ( suc @ M2 ) ) ) ).

% not0_implies_Suc
thf(fact_90_list_Odistinct_I1_J,axiom,
    ! [A: $tType,X21: A,X22: list @ A] :
      ( ( nil @ A )
     != ( cons @ A @ X21 @ X22 ) ) ).

% list.distinct(1)
thf(fact_91_list_OdiscI,axiom,
    ! [A: $tType,List: list @ A,X21: A,X22: list @ A] :
      ( ( List
        = ( cons @ A @ X21 @ X22 ) )
     => ( List
       != ( nil @ A ) ) ) ).

% list.discI
thf(fact_92_list_Oexhaust,axiom,
    ! [A: $tType,Y: list @ A] :
      ( ( Y
       != ( nil @ A ) )
     => ~ ! [X212: A,X222: list @ A] :
            ( Y
           != ( cons @ A @ X212 @ X222 ) ) ) ).

% list.exhaust
thf(fact_93_list_Oinducts,axiom,
    ! [A: $tType,P: ( list @ A ) > $o,List: list @ A] :
      ( ( P @ ( nil @ A ) )
     => ( ! [X12: A,X23: list @ A] :
            ( ( P @ X23 )
           => ( P @ ( cons @ A @ X12 @ X23 ) ) )
       => ( P @ List ) ) ) ).

% list.inducts
thf(fact_94_neq__Nil__conv,axiom,
    ! [A: $tType,Xs: list @ A] :
      ( ( Xs
       != ( nil @ A ) )
      = ( ? [Y3: A,Ys: list @ A] :
            ( Xs
            = ( cons @ A @ Y3 @ Ys ) ) ) ) ).

% neq_Nil_conv
thf(fact_95_list__induct2_H,axiom,
    ! [A: $tType,B: $tType,P: ( list @ A ) > ( list @ B ) > $o,Xs: list @ A,Ys2: list @ B] :
      ( ( P @ ( nil @ A ) @ ( nil @ B ) )
     => ( ! [X3: A,Xs2: list @ A] : ( P @ ( cons @ A @ X3 @ Xs2 ) @ ( nil @ B ) )
       => ( ! [Y2: B,Ys3: list @ B] : ( P @ ( nil @ A ) @ ( cons @ B @ Y2 @ Ys3 ) )
         => ( ! [X3: A,Xs2: list @ A,Y2: B,Ys3: list @ B] :
                ( ( P @ Xs2 @ Ys3 )
               => ( P @ ( cons @ A @ X3 @ Xs2 ) @ ( cons @ B @ Y2 @ Ys3 ) ) )
           => ( P @ Xs @ Ys2 ) ) ) ) ) ).

% list_induct2'
thf(fact_96_splice_Oinduct,axiom,
    ! [A: $tType,P: ( list @ A ) > ( list @ A ) > $o,A0: list @ A,A1: list @ A] :
      ( ! [X_1: list @ A] : ( P @ ( nil @ A ) @ X_1 )
     => ( ! [X3: A,Xs2: list @ A,Ys3: list @ A] :
            ( ( P @ Ys3 @ Xs2 )
           => ( P @ ( cons @ A @ X3 @ Xs2 ) @ Ys3 ) )
       => ( P @ A0 @ A1 ) ) ) ).

% splice.induct
thf(fact_97_induct__list012,axiom,
    ! [A: $tType,P: ( list @ A ) > $o,Xs: list @ A] :
      ( ( P @ ( nil @ A ) )
     => ( ! [X3: A] : ( P @ ( cons @ A @ X3 @ ( nil @ A ) ) )
       => ( ! [X3: A,Y2: A,Zs: list @ A] :
              ( ( P @ Zs )
             => ( ( P @ ( cons @ A @ Y2 @ Zs ) )
               => ( P @ ( cons @ A @ X3 @ ( cons @ A @ Y2 @ Zs ) ) ) ) )
         => ( P @ Xs ) ) ) ) ).

% induct_list012
thf(fact_98_min__list_Ocases,axiom,
    ! [A: $tType] :
      ( ( ord @ A )
     => ! [X: list @ A] :
          ( ! [X3: A,Xs2: list @ A] :
              ( X
             != ( cons @ A @ X3 @ Xs2 ) )
         => ( X
            = ( nil @ A ) ) ) ) ).

% min_list.cases
thf(fact_99_min__list_Oinduct,axiom,
    ! [A: $tType] :
      ( ( ord @ A )
     => ! [P: ( list @ A ) > $o,A0: list @ A] :
          ( ! [X3: A,Xs2: list @ A] :
              ( ! [X213: A,X223: list @ A] :
                  ( ( Xs2
                    = ( cons @ A @ X213 @ X223 ) )
                 => ( P @ Xs2 ) )
             => ( P @ ( cons @ A @ X3 @ Xs2 ) ) )
         => ( ( P @ ( nil @ A ) )
           => ( P @ A0 ) ) ) ) ).

% min_list.induct
thf(fact_100_shuffles_Oinduct,axiom,
    ! [A: $tType,P: ( list @ A ) > ( list @ A ) > $o,A0: list @ A,A1: list @ A] :
      ( ! [X_1: list @ A] : ( P @ ( nil @ A ) @ X_1 )
     => ( ! [Xs2: list @ A] : ( P @ Xs2 @ ( nil @ A ) )
       => ( ! [X3: A,Xs2: list @ A,Y2: A,Ys3: list @ A] :
              ( ( P @ Xs2 @ ( cons @ A @ Y2 @ Ys3 ) )
             => ( ( P @ ( cons @ A @ X3 @ Xs2 ) @ Ys3 )
               => ( P @ ( cons @ A @ X3 @ Xs2 ) @ ( cons @ A @ Y2 @ Ys3 ) ) ) )
         => ( P @ A0 @ A1 ) ) ) ) ).

% shuffles.induct
thf(fact_101_transpose_Ocases,axiom,
    ! [A: $tType,X: list @ ( list @ A )] :
      ( ( X
       != ( nil @ ( list @ A ) ) )
     => ( ! [Xss: list @ ( list @ A )] :
            ( X
           != ( cons @ ( list @ A ) @ ( nil @ A ) @ Xss ) )
       => ~ ! [X3: A,Xs2: list @ A,Xss: list @ ( list @ A )] :
              ( X
             != ( cons @ ( list @ A ) @ ( cons @ A @ X3 @ Xs2 ) @ Xss ) ) ) ) ).

% transpose.cases
thf(fact_102_remdups__adj_Ocases,axiom,
    ! [A: $tType,X: list @ A] :
      ( ( X
       != ( nil @ A ) )
     => ( ! [X3: A] :
            ( X
           != ( cons @ A @ X3 @ ( nil @ A ) ) )
       => ~ ! [X3: A,Y2: A,Xs2: list @ A] :
              ( X
             != ( cons @ A @ X3 @ ( cons @ A @ Y2 @ Xs2 ) ) ) ) ) ).

% remdups_adj.cases
thf(fact_103_sorted__wrt_Oinduct,axiom,
    ! [A: $tType,P: ( A > A > $o ) > ( list @ A ) > $o,A0: A > A > $o,A1: list @ A] :
      ( ! [P3: A > A > $o] : ( P @ P3 @ ( nil @ A ) )
     => ( ! [P3: A > A > $o,X3: A,Ys3: list @ A] :
            ( ( P @ P3 @ Ys3 )
           => ( P @ P3 @ ( cons @ A @ X3 @ Ys3 ) ) )
       => ( P @ A0 @ A1 ) ) ) ).

% sorted_wrt.induct
thf(fact_104_remdups__adj_Oinduct,axiom,
    ! [A: $tType,P: ( list @ A ) > $o,A0: list @ A] :
      ( ( P @ ( nil @ A ) )
     => ( ! [X3: A] : ( P @ ( cons @ A @ X3 @ ( nil @ A ) ) )
       => ( ! [X3: A,Y2: A,Xs2: list @ A] :
              ( ( ( X3 = Y2 )
               => ( P @ ( cons @ A @ X3 @ Xs2 ) ) )
             => ( ( ( X3 != Y2 )
                 => ( P @ ( cons @ A @ Y2 @ Xs2 ) ) )
               => ( P @ ( cons @ A @ X3 @ ( cons @ A @ Y2 @ Xs2 ) ) ) ) )
         => ( P @ A0 ) ) ) ) ).

% remdups_adj.induct
thf(fact_105_arg__min__list_Oinduct,axiom,
    ! [B: $tType,A: $tType] :
      ( ( linorder @ B )
     => ! [P: ( A > B ) > ( list @ A ) > $o,A0: A > B,A1: list @ A] :
          ( ! [F2: A > B,X3: A] : ( P @ F2 @ ( cons @ A @ X3 @ ( nil @ A ) ) )
         => ( ! [F2: A > B,X3: A,Y2: A,Zs: list @ A] :
                ( ( P @ F2 @ ( cons @ A @ Y2 @ Zs ) )
               => ( P @ F2 @ ( cons @ A @ X3 @ ( cons @ A @ Y2 @ Zs ) ) ) )
           => ( ! [A3: A > B] : ( P @ A3 @ ( nil @ A ) )
             => ( P @ A0 @ A1 ) ) ) ) ) ).

% arg_min_list.induct
thf(fact_106_successively_Oinduct,axiom,
    ! [A: $tType,P: ( A > A > $o ) > ( list @ A ) > $o,A0: A > A > $o,A1: list @ A] :
      ( ! [P3: A > A > $o] : ( P @ P3 @ ( nil @ A ) )
     => ( ! [P3: A > A > $o,X3: A] : ( P @ P3 @ ( cons @ A @ X3 @ ( nil @ A ) ) )
       => ( ! [P3: A > A > $o,X3: A,Y2: A,Xs2: list @ A] :
              ( ( P @ P3 @ ( cons @ A @ Y2 @ Xs2 ) )
             => ( P @ P3 @ ( cons @ A @ X3 @ ( cons @ A @ Y2 @ Xs2 ) ) ) )
         => ( P @ A0 @ A1 ) ) ) ) ).

% successively.induct
thf(fact_107_list__nonempty__induct,axiom,
    ! [A: $tType,Xs: list @ A,P: ( list @ A ) > $o] :
      ( ( Xs
       != ( nil @ A ) )
     => ( ! [X3: A] : ( P @ ( cons @ A @ X3 @ ( nil @ A ) ) )
       => ( ! [X3: A,Xs2: list @ A] :
              ( ( Xs2
               != ( nil @ A ) )
             => ( ( P @ Xs2 )
               => ( P @ ( cons @ A @ X3 @ Xs2 ) ) ) )
         => ( P @ Xs ) ) ) ) ).

% list_nonempty_induct
thf(fact_108_map__tailrec__rev_Oinduct,axiom,
    ! [A: $tType,B: $tType,P: ( A > B ) > ( list @ A ) > ( list @ B ) > $o,A0: A > B,A1: list @ A,A22: list @ B] :
      ( ! [F2: A > B,X_1: list @ B] : ( P @ F2 @ ( nil @ A ) @ X_1 )
     => ( ! [F2: A > B,A3: A,As: list @ A,Bs: list @ B] :
            ( ( P @ F2 @ As @ ( cons @ B @ ( F2 @ A3 ) @ Bs ) )
           => ( P @ F2 @ ( cons @ A @ A3 @ As ) @ Bs ) )
       => ( P @ A0 @ A1 @ A22 ) ) ) ).

% map_tailrec_rev.induct
thf(fact_109_strict__sorted_Ocases,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [X: list @ A] :
          ( ( X
           != ( nil @ A ) )
         => ~ ! [X3: A,Ys3: list @ A] :
                ( X
               != ( cons @ A @ X3 @ Ys3 ) ) ) ) ).

% strict_sorted.cases
thf(fact_110_strict__sorted_Oinduct,axiom,
    ! [A: $tType] :
      ( ( linorder @ A )
     => ! [P: ( list @ A ) > $o,A0: list @ A] :
          ( ( P @ ( nil @ A ) )
         => ( ! [X3: A,Ys3: list @ A] :
                ( ( P @ Ys3 )
               => ( P @ ( cons @ A @ X3 @ Ys3 ) ) )
           => ( P @ A0 ) ) ) ) ).

% strict_sorted.induct
thf(fact_111_splice_Ocases,axiom,
    ! [A: $tType,X: product_prod @ ( list @ A ) @ ( list @ A )] :
      ( ! [Ys3: list @ A] :
          ( X
         != ( product_Pair @ ( list @ A ) @ ( list @ A ) @ ( nil @ A ) @ Ys3 ) )
     => ~ ! [X3: A,Xs2: list @ A,Ys3: list @ A] :
            ( X
           != ( product_Pair @ ( list @ A ) @ ( list @ A ) @ ( cons @ A @ X3 @ Xs2 ) @ Ys3 ) ) ) ).

% splice.cases
thf(fact_112_shuffles_Ocases,axiom,
    ! [A: $tType,X: product_prod @ ( list @ A ) @ ( list @ A )] :
      ( ! [Ys3: list @ A] :
          ( X
         != ( product_Pair @ ( list @ A ) @ ( list @ A ) @ ( nil @ A ) @ Ys3 ) )
     => ( ! [Xs2: list @ A] :
            ( X
           != ( product_Pair @ ( list @ A ) @ ( list @ A ) @ Xs2 @ ( nil @ A ) ) )
       => ~ ! [X3: A,Xs2: list @ A,Y2: A,Ys3: list @ A] :
              ( X
             != ( product_Pair @ ( list @ A ) @ ( list @ A ) @ ( cons @ A @ X3 @ Xs2 ) @ ( cons @ A @ Y2 @ Ys3 ) ) ) ) ) ).

% shuffles.cases
thf(fact_113_sorted__wrt_Ocases,axiom,
    ! [A: $tType,X: product_prod @ ( A > A > $o ) @ ( list @ A )] :
      ( ! [P3: A > A > $o] :
          ( X
         != ( product_Pair @ ( A > A > $o ) @ ( list @ A ) @ P3 @ ( nil @ A ) ) )
     => ~ ! [P3: A > A > $o,X3: A,Ys3: list @ A] :
            ( X
           != ( product_Pair @ ( A > A > $o ) @ ( list @ A ) @ P3 @ ( cons @ A @ X3 @ Ys3 ) ) ) ) ).

% sorted_wrt.cases
thf(fact_114_successively_Ocases,axiom,
    ! [A: $tType,X: product_prod @ ( A > A > $o ) @ ( list @ A )] :
      ( ! [P3: A > A > $o] :
          ( X
         != ( product_Pair @ ( A > A > $o ) @ ( list @ A ) @ P3 @ ( nil @ A ) ) )
     => ( ! [P3: A > A > $o,X3: A] :
            ( X
           != ( product_Pair @ ( A > A > $o ) @ ( list @ A ) @ P3 @ ( cons @ A @ X3 @ ( nil @ A ) ) ) )
       => ~ ! [P3: A > A > $o,X3: A,Y2: A,Xs2: list @ A] :
              ( X
             != ( product_Pair @ ( A > A > $o ) @ ( list @ A ) @ P3 @ ( cons @ A @ X3 @ ( cons @ A @ Y2 @ Xs2 ) ) ) ) ) ) ).

% successively.cases
thf(fact_115_arg__min__list_Ocases,axiom,
    ! [B: $tType,A: $tType] :
      ( ( linorder @ B )
     => ! [X: product_prod @ ( A > B ) @ ( list @ A )] :
          ( ! [F2: A > B,X3: A] :
              ( X
             != ( product_Pair @ ( A > B ) @ ( list @ A ) @ F2 @ ( cons @ A @ X3 @ ( nil @ A ) ) ) )
         => ( ! [F2: A > B,X3: A,Y2: A,Zs: list @ A] :
                ( X
               != ( product_Pair @ ( A > B ) @ ( list @ A ) @ F2 @ ( cons @ A @ X3 @ ( cons @ A @ Y2 @ Zs ) ) ) )
           => ~ ! [A3: A > B] :
                  ( X
                 != ( product_Pair @ ( A > B ) @ ( list @ A ) @ A3 @ ( nil @ A ) ) ) ) ) ) ).

% arg_min_list.cases
thf(fact_116_map__tailrec__rev_Ocases,axiom,
    ! [A: $tType,B: $tType,X: product_prod @ ( A > B ) @ ( product_prod @ ( list @ A ) @ ( list @ B ) )] :
      ( ! [F2: A > B,Bs: list @ B] :
          ( X
         != ( product_Pair @ ( A > B ) @ ( product_prod @ ( list @ A ) @ ( list @ B ) ) @ F2 @ ( product_Pair @ ( list @ A ) @ ( list @ B ) @ ( nil @ A ) @ Bs ) ) )
     => ~ ! [F2: A > B,A3: A,As: list @ A,Bs: list @ B] :
            ( X
           != ( product_Pair @ ( A > B ) @ ( product_prod @ ( list @ A ) @ ( list @ B ) ) @ F2 @ ( product_Pair @ ( list @ A ) @ ( list @ B ) @ ( cons @ A @ A3 @ As ) @ Bs ) ) ) ) ).

% map_tailrec_rev.cases
thf(fact_117_exec__impl__execs,axiom,
    ! [S: state,C: com,S2: state,Cs3: list @ com] :
      ( ( exec @ S @ C @ S2 )
     => ( member @ ( product_prod @ ( product_prod @ ( list @ com ) @ state ) @ ( product_prod @ ( list @ com ) @ state ) ) @ ( product_Pair @ ( product_prod @ ( list @ com ) @ state ) @ ( product_prod @ ( list @ com ) @ state ) @ ( product_Pair @ ( list @ com ) @ state @ ( cons @ com @ C @ Cs3 ) @ S ) @ ( product_Pair @ ( list @ com ) @ state @ Cs3 @ S2 ) ) @ ( transitive_rtrancl @ ( product_prod @ ( list @ com ) @ state ) @ pHoare1053570893_exec1 ) ) ) ).

% exec_impl_execs
thf(fact_118_prod__cases3,axiom,
    ! [A: $tType,B: $tType,C5: $tType,Y: product_prod @ A @ ( product_prod @ B @ C5 )] :
      ~ ! [A3: A,B3: B,C3: C5] :
          ( Y
         != ( product_Pair @ A @ ( product_prod @ B @ C5 ) @ A3 @ ( product_Pair @ B @ C5 @ B3 @ C3 ) ) ) ).

% prod_cases3
thf(fact_119_prod__cases4,axiom,
    ! [A: $tType,B: $tType,C5: $tType,D: $tType,Y: product_prod @ A @ ( product_prod @ B @ ( product_prod @ C5 @ D ) )] :
      ~ ! [A3: A,B3: B,C3: C5,D2: D] :
          ( Y
         != ( product_Pair @ A @ ( product_prod @ B @ ( product_prod @ C5 @ D ) ) @ A3 @ ( product_Pair @ B @ ( product_prod @ C5 @ D ) @ B3 @ ( product_Pair @ C5 @ D @ C3 @ D2 ) ) ) ) ).

% prod_cases4
thf(fact_120_prod__cases5,axiom,
    ! [A: $tType,B: $tType,C5: $tType,D: $tType,E: $tType,Y: product_prod @ A @ ( product_prod @ B @ ( product_prod @ C5 @ ( product_prod @ D @ E ) ) )] :
      ~ ! [A3: A,B3: B,C3: C5,D2: D,E2: E] :
          ( Y
         != ( product_Pair @ A @ ( product_prod @ B @ ( product_prod @ C5 @ ( product_prod @ D @ E ) ) ) @ A3 @ ( product_Pair @ B @ ( product_prod @ C5 @ ( product_prod @ D @ E ) ) @ B3 @ ( product_Pair @ C5 @ ( product_prod @ D @ E ) @ C3 @ ( product_Pair @ D @ E @ D2 @ E2 ) ) ) ) ) ).

% prod_cases5
thf(fact_121_prod__cases6,axiom,
    ! [A: $tType,B: $tType,C5: $tType,D: $tType,E: $tType,F4: $tType,Y: product_prod @ A @ ( product_prod @ B @ ( product_prod @ C5 @ ( product_prod @ D @ ( product_prod @ E @ F4 ) ) ) )] :
      ~ ! [A3: A,B3: B,C3: C5,D2: D,E2: E,F2: F4] :
          ( Y
         != ( product_Pair @ A @ ( product_prod @ B @ ( product_prod @ C5 @ ( product_prod @ D @ ( product_prod @ E @ F4 ) ) ) ) @ A3 @ ( product_Pair @ B @ ( product_prod @ C5 @ ( product_prod @ D @ ( product_prod @ E @ F4 ) ) ) @ B3 @ ( product_Pair @ C5 @ ( product_prod @ D @ ( product_prod @ E @ F4 ) ) @ C3 @ ( product_Pair @ D @ ( product_prod @ E @ F4 ) @ D2 @ ( product_Pair @ E @ F4 @ E2 @ F2 ) ) ) ) ) ) ).

% prod_cases6
thf(fact_122_prod__cases7,axiom,
    ! [A: $tType,B: $tType,C5: $tType,D: $tType,E: $tType,F4: $tType,G: $tType,Y: product_prod @ A @ ( product_prod @ B @ ( product_prod @ C5 @ ( product_prod @ D @ ( product_prod @ E @ ( product_prod @ F4 @ G ) ) ) ) )] :
      ~ ! [A3: A,B3: B,C3: C5,D2: D,E2: E,F2: F4,G2: G] :
          ( Y
         != ( product_Pair @ A @ ( product_prod @ B @ ( product_prod @ C5 @ ( product_prod @ D @ ( product_prod @ E @ ( product_prod @ F4 @ G ) ) ) ) ) @ A3 @ ( product_Pair @ B @ ( product_prod @ C5 @ ( product_prod @ D @ ( product_prod @ E @ ( product_prod @ F4 @ G ) ) ) ) @ B3 @ ( product_Pair @ C5 @ ( product_prod @ D @ ( product_prod @ E @ ( product_prod @ F4 @ G ) ) ) @ C3 @ ( product_Pair @ D @ ( product_prod @ E @ ( product_prod @ F4 @ G ) ) @ D2 @ ( product_Pair @ E @ ( product_prod @ F4 @ G ) @ E2 @ ( product_Pair @ F4 @ G @ F2 @ G2 ) ) ) ) ) ) ) ).

% prod_cases7
thf(fact_123_prod__induct3,axiom,
    ! [C5: $tType,B: $tType,A: $tType,P: ( product_prod @ A @ ( product_prod @ B @ C5 ) ) > $o,X: product_prod @ A @ ( product_prod @ B @ C5 )] :
      ( ! [A3: A,B3: B,C3: C5] : ( P @ ( product_Pair @ A @ ( product_prod @ B @ C5 ) @ A3 @ ( product_Pair @ B @ C5 @ B3 @ C3 ) ) )
     => ( P @ X ) ) ).

% prod_induct3
thf(fact_124_prod__induct4,axiom,
    ! [D: $tType,C5: $tType,B: $tType,A: $tType,P: ( product_prod @ A @ ( product_prod @ B @ ( product_prod @ C5 @ D ) ) ) > $o,X: product_prod @ A @ ( product_prod @ B @ ( product_prod @ C5 @ D ) )] :
      ( ! [A3: A,B3: B,C3: C5,D2: D] : ( P @ ( product_Pair @ A @ ( product_prod @ B @ ( product_prod @ C5 @ D ) ) @ A3 @ ( product_Pair @ B @ ( product_prod @ C5 @ D ) @ B3 @ ( product_Pair @ C5 @ D @ C3 @ D2 ) ) ) )
     => ( P @ X ) ) ).

% prod_induct4
thf(fact_125_prod__induct5,axiom,
    ! [E: $tType,D: $tType,C5: $tType,B: $tType,A: $tType,P: ( product_prod @ A @ ( product_prod @ B @ ( product_prod @ C5 @ ( product_prod @ D @ E ) ) ) ) > $o,X: product_prod @ A @ ( product_prod @ B @ ( product_prod @ C5 @ ( product_prod @ D @ E ) ) )] :
      ( ! [A3: A,B3: B,C3: C5,D2: D,E2: E] : ( P @ ( product_Pair @ A @ ( product_prod @ B @ ( product_prod @ C5 @ ( product_prod @ D @ E ) ) ) @ A3 @ ( product_Pair @ B @ ( product_prod @ C5 @ ( product_prod @ D @ E ) ) @ B3 @ ( product_Pair @ C5 @ ( product_prod @ D @ E ) @ C3 @ ( product_Pair @ D @ E @ D2 @ E2 ) ) ) ) )
     => ( P @ X ) ) ).

% prod_induct5
thf(fact_126_prod__induct6,axiom,
    ! [F4: $tType,E: $tType,D: $tType,C5: $tType,B: $tType,A: $tType,P: ( product_prod @ A @ ( product_prod @ B @ ( product_prod @ C5 @ ( product_prod @ D @ ( product_prod @ E @ F4 ) ) ) ) ) > $o,X: product_prod @ A @ ( product_prod @ B @ ( product_prod @ C5 @ ( product_prod @ D @ ( product_prod @ E @ F4 ) ) ) )] :
      ( ! [A3: A,B3: B,C3: C5,D2: D,E2: E,F2: F4] : ( P @ ( product_Pair @ A @ ( product_prod @ B @ ( product_prod @ C5 @ ( product_prod @ D @ ( product_prod @ E @ F4 ) ) ) ) @ A3 @ ( product_Pair @ B @ ( product_prod @ C5 @ ( product_prod @ D @ ( product_prod @ E @ F4 ) ) ) @ B3 @ ( product_Pair @ C5 @ ( product_prod @ D @ ( product_prod @ E @ F4 ) ) @ C3 @ ( product_Pair @ D @ ( product_prod @ E @ F4 ) @ D2 @ ( product_Pair @ E @ F4 @ E2 @ F2 ) ) ) ) ) )
     => ( P @ X ) ) ).

% prod_induct6
thf(fact_127_prod__induct7,axiom,
    ! [G: $tType,F4: $tType,E: $tType,D: $tType,C5: $tType,B: $tType,A: $tType,P: ( product_prod @ A @ ( product_prod @ B @ ( product_prod @ C5 @ ( product_prod @ D @ ( product_prod @ E @ ( product_prod @ F4 @ G ) ) ) ) ) ) > $o,X: product_prod @ A @ ( product_prod @ B @ ( product_prod @ C5 @ ( product_prod @ D @ ( product_prod @ E @ ( product_prod @ F4 @ G ) ) ) ) )] :
      ( ! [A3: A,B3: B,C3: C5,D2: D,E2: E,F2: F4,G2: G] : ( P @ ( product_Pair @ A @ ( product_prod @ B @ ( product_prod @ C5 @ ( product_prod @ D @ ( product_prod @ E @ ( product_prod @ F4 @ G ) ) ) ) ) @ A3 @ ( product_Pair @ B @ ( product_prod @ C5 @ ( product_prod @ D @ ( product_prod @ E @ ( product_prod @ F4 @ G ) ) ) ) @ B3 @ ( product_Pair @ C5 @ ( product_prod @ D @ ( product_prod @ E @ ( product_prod @ F4 @ G ) ) ) @ C3 @ ( product_Pair @ D @ ( product_prod @ E @ ( product_prod @ F4 @ G ) ) @ D2 @ ( product_Pair @ E @ ( product_prod @ F4 @ G ) @ E2 @ ( product_Pair @ F4 @ G @ F2 @ G2 ) ) ) ) ) ) )
     => ( P @ X ) ) ).

% prod_induct7
thf(fact_128_exec1__pres__termis,axiom,
    ! [Cs3: list @ com,S: state,Cs: list @ com,S2: state] :
      ( ( member @ ( product_prod @ ( product_prod @ ( list @ com ) @ state ) @ ( product_prod @ ( list @ com ) @ state ) ) @ ( product_Pair @ ( product_prod @ ( list @ com ) @ state ) @ ( product_prod @ ( list @ com ) @ state ) @ ( product_Pair @ ( list @ com ) @ state @ Cs3 @ S ) @ ( product_Pair @ ( list @ com ) @ state @ Cs @ S2 ) ) @ pHoare1053570893_exec1 )
     => ( ( pHoare1335526537termis @ Cs3 @ S )
       => ( pHoare1335526537termis @ Cs @ S2 ) ) ) ).

% exec1_pres_termis
thf(fact_129_old_Oprod_Orec,axiom,
    ! [A: $tType,T: $tType,B: $tType,F1: A > B > T,A2: A,B2: B] :
      ( ( product_rec_prod @ A @ B @ T @ F1 @ ( product_Pair @ A @ B @ A2 @ B2 ) )
      = ( F1 @ A2 @ B2 ) ) ).

% old.prod.rec
thf(fact_130_dependent__nat__choice,axiom,
    ! [A: $tType,P: nat > A > $o,Q: nat > A > A > $o] :
      ( ? [X_12: A] : ( P @ ( zero_zero @ nat ) @ X_12 )
     => ( ! [X3: A,N2: nat] :
            ( ( P @ N2 @ X3 )
           => ? [Y4: A] :
                ( ( P @ ( suc @ N2 ) @ Y4 )
                & ( Q @ N2 @ X3 @ Y4 ) ) )
       => ? [F2: nat > A] :
          ! [N3: nat] :
            ( ( P @ N3 @ ( F2 @ N3 ) )
            & ( Q @ N3 @ ( F2 @ N3 ) @ ( F2 @ ( suc @ N3 ) ) ) ) ) ) ).

% dependent_nat_choice
thf(fact_131_exec1E_I3_J,axiom,
    ! [C1: com,C22: com,Cs3: list @ com,S: state,Cs: list @ com,S2: state] :
      ( ( member @ ( product_prod @ ( product_prod @ ( list @ com ) @ state ) @ ( product_prod @ ( list @ com ) @ state ) ) @ ( product_Pair @ ( product_prod @ ( list @ com ) @ state ) @ ( product_prod @ ( list @ com ) @ state ) @ ( product_Pair @ ( list @ com ) @ state @ ( cons @ com @ ( semi @ C1 @ C22 ) @ Cs3 ) @ S ) @ ( product_Pair @ ( list @ com ) @ state @ Cs @ S2 ) ) @ pHoare1053570893_exec1 )
     => ~ ( ( Cs
            = ( cons @ com @ C1 @ ( cons @ com @ C22 @ Cs3 ) ) )
         => ( S2 != S ) ) ) ).

% exec1E(3)
thf(fact_132_exec1_OSemi,axiom,
    ! [C1: com,C22: com,Cs3: list @ com,S: state] : ( member @ ( product_prod @ ( product_prod @ ( list @ com ) @ state ) @ ( product_prod @ ( list @ com ) @ state ) ) @ ( product_Pair @ ( product_prod @ ( list @ com ) @ state ) @ ( product_prod @ ( list @ com ) @ state ) @ ( product_Pair @ ( list @ com ) @ state @ ( cons @ com @ ( semi @ C1 @ C22 ) @ Cs3 ) @ S ) @ ( product_Pair @ ( list @ com ) @ state @ ( cons @ com @ C1 @ ( cons @ com @ C22 @ Cs3 ) ) @ S ) ) @ pHoare1053570893_exec1 ) ).

% exec1.Semi
thf(fact_133_n__lists__Nil,axiom,
    ! [A: $tType,N: nat] :
      ( ( ( N
          = ( zero_zero @ nat ) )
       => ( ( n_lists @ A @ N @ ( nil @ A ) )
          = ( cons @ ( list @ A ) @ ( nil @ A ) @ ( nil @ ( list @ A ) ) ) ) )
      & ( ( N
         != ( zero_zero @ nat ) )
       => ( ( n_lists @ A @ N @ ( nil @ A ) )
          = ( nil @ ( list @ A ) ) ) ) ) ).

% n_lists_Nil
thf(fact_134_exec1E_I2_J,axiom,
    ! [F: state > ( set @ state ),Cs3: list @ com,S: state,Cs: list @ com,S2: state] :
      ( ( member @ ( product_prod @ ( product_prod @ ( list @ com ) @ state ) @ ( product_prod @ ( list @ com ) @ state ) ) @ ( product_Pair @ ( product_prod @ ( list @ com ) @ state ) @ ( product_prod @ ( list @ com ) @ state ) @ ( product_Pair @ ( list @ com ) @ state @ ( cons @ com @ ( do @ F ) @ Cs3 ) @ S ) @ ( product_Pair @ ( list @ com ) @ state @ Cs @ S2 ) ) @ pHoare1053570893_exec1 )
     => ~ ( ( Cs = Cs3 )
         => ~ ( member @ state @ S2 @ ( F @ S ) ) ) ) ).

% exec1E(2)
thf(fact_135_exec1_ODo,axiom,
    ! [T2: state,F: state > ( set @ state ),S: state,Cs3: list @ com] :
      ( ( member @ state @ T2 @ ( F @ S ) )
     => ( member @ ( product_prod @ ( product_prod @ ( list @ com ) @ state ) @ ( product_prod @ ( list @ com ) @ state ) ) @ ( product_Pair @ ( product_prod @ ( list @ com ) @ state ) @ ( product_prod @ ( list @ com ) @ state ) @ ( product_Pair @ ( list @ com ) @ state @ ( cons @ com @ ( do @ F ) @ Cs3 ) @ S ) @ ( product_Pair @ ( list @ com ) @ state @ Cs3 @ T2 ) ) @ pHoare1053570893_exec1 ) ) ).

% exec1.Do
thf(fact_136_n__lists_Osimps_I1_J,axiom,
    ! [A: $tType,Xs: list @ A] :
      ( ( n_lists @ A @ ( zero_zero @ nat ) @ Xs )
      = ( cons @ ( list @ A ) @ ( nil @ A ) @ ( nil @ ( list @ A ) ) ) ) ).

% n_lists.simps(1)
thf(fact_137_termi_OSemi,axiom,
    ! [C1: com,S0: state,C22: com] :
      ( ( termi @ C1 @ S0 )
     => ( ! [S1: state] :
            ( ( exec @ S0 @ C1 @ S1 )
           => ( termi @ C22 @ S1 ) )
       => ( termi @ ( semi @ C1 @ C22 ) @ S0 ) ) ) ).

% termi.Semi
thf(fact_138_com_Oinject_I2_J,axiom,
    ! [X21: com,X22: com,Y21: com,Y222: com] :
      ( ( ( semi @ X21 @ X22 )
        = ( semi @ Y21 @ Y222 ) )
      = ( ( X21 = Y21 )
        & ( X22 = Y222 ) ) ) ).

% com.inject(2)
thf(fact_139_com_Oinject_I1_J,axiom,
    ! [X1: state > ( set @ state ),Y1: state > ( set @ state )] :
      ( ( ( do @ X1 )
        = ( do @ Y1 ) )
      = ( X1 = Y1 ) ) ).

% com.inject(1)
thf(fact_140_com_Odistinct_I1_J,axiom,
    ! [X1: state > ( set @ state ),X21: com,X22: com] :
      ( ( do @ X1 )
     != ( semi @ X21 @ X22 ) ) ).

% com.distinct(1)
thf(fact_141_exec_ODo,axiom,
    ! [T2: state,F: state > ( set @ state ),S: state] :
      ( ( member @ state @ T2 @ ( F @ S ) )
     => ( exec @ S @ ( do @ F ) @ T2 ) ) ).

% exec.Do
thf(fact_142_exec_OSemi,axiom,
    ! [S0: state,C1: com,S12: state,C22: com,S22: state] :
      ( ( exec @ S0 @ C1 @ S12 )
     => ( ( exec @ S12 @ C22 @ S22 )
       => ( exec @ S0 @ ( semi @ C1 @ C22 ) @ S22 ) ) ) ).

% exec.Semi
thf(fact_143_product__lists_Osimps_I1_J,axiom,
    ! [A: $tType] :
      ( ( product_lists @ A @ ( nil @ ( list @ A ) ) )
      = ( cons @ ( list @ A ) @ ( nil @ A ) @ ( nil @ ( list @ A ) ) ) ) ).

% product_lists.simps(1)
thf(fact_144_subseqs_Osimps_I1_J,axiom,
    ! [A: $tType] :
      ( ( subseqs @ A @ ( nil @ A ) )
      = ( cons @ ( list @ A ) @ ( nil @ A ) @ ( nil @ ( list @ A ) ) ) ) ).

% subseqs.simps(1)
thf(fact_145_exec1E_I4_J,axiom,
    ! [B2: state > $o,C1: com,C22: com,Cs3: list @ com,S: state,Cs: list @ com,S2: state] :
      ( ( member @ ( product_prod @ ( product_prod @ ( list @ com ) @ state ) @ ( product_prod @ ( list @ com ) @ state ) ) @ ( product_Pair @ ( product_prod @ ( list @ com ) @ state ) @ ( product_prod @ ( list @ com ) @ state ) @ ( product_Pair @ ( list @ com ) @ state @ ( cons @ com @ ( cond @ B2 @ C1 @ C22 ) @ Cs3 ) @ S ) @ ( product_Pair @ ( list @ com ) @ state @ Cs @ S2 ) ) @ pHoare1053570893_exec1 )
     => ( ( ( Cs
            = ( cons @ com @ C1 @ Cs3 ) )
         => ( ( S2 = S )
           => ~ ( B2 @ S ) ) )
       => ~ ( ( Cs
              = ( cons @ com @ C22 @ Cs3 ) )
           => ( ( S2 = S )
             => ( B2 @ S ) ) ) ) ) ).

% exec1E(4)
thf(fact_146_com_Oinject_I3_J,axiom,
    ! [X31: state > $o,X322: com,X33: com,Y31: state > $o,Y32: com,Y33: com] :
      ( ( ( cond @ X31 @ X322 @ X33 )
        = ( cond @ Y31 @ Y32 @ Y33 ) )
      = ( ( X31 = Y31 )
        & ( X322 = Y32 )
        & ( X33 = Y33 ) ) ) ).

% com.inject(3)
thf(fact_147_exec_OIfTrue,axiom,
    ! [B2: state > $o,S: state,C1: com,T2: state,C22: com] :
      ( ( B2 @ S )
     => ( ( exec @ S @ C1 @ T2 )
       => ( exec @ S @ ( cond @ B2 @ C1 @ C22 ) @ T2 ) ) ) ).

% exec.IfTrue
thf(fact_148_exec_OIfFalse,axiom,
    ! [B2: state > $o,S: state,C22: com,T2: state,C1: com] :
      ( ~ ( B2 @ S )
     => ( ( exec @ S @ C22 @ T2 )
       => ( exec @ S @ ( cond @ B2 @ C1 @ C22 ) @ T2 ) ) ) ).

% exec.IfFalse
thf(fact_149_termi_OIfTrue,axiom,
    ! [B2: state > $o,S: state,C1: com,C22: com] :
      ( ( B2 @ S )
     => ( ( termi @ C1 @ S )
       => ( termi @ ( cond @ B2 @ C1 @ C22 ) @ S ) ) ) ).

% termi.IfTrue
thf(fact_150_termi_OIfFalse,axiom,
    ! [B2: state > $o,S: state,C22: com,C1: com] :
      ( ~ ( B2 @ S )
     => ( ( termi @ C22 @ S )
       => ( termi @ ( cond @ B2 @ C1 @ C22 ) @ S ) ) ) ).

% termi.IfFalse
thf(fact_151_com_Odistinct_I3_J,axiom,
    ! [X1: state > ( set @ state ),X31: state > $o,X322: com,X33: com] :
      ( ( do @ X1 )
     != ( cond @ X31 @ X322 @ X33 ) ) ).

% com.distinct(3)
thf(fact_152_com_Odistinct_I11_J,axiom,
    ! [X21: com,X22: com,X31: state > $o,X322: com,X33: com] :
      ( ( semi @ X21 @ X22 )
     != ( cond @ X31 @ X322 @ X33 ) ) ).

% com.distinct(11)
thf(fact_153_exec1_OIfFalse,axiom,
    ! [B2: state > $o,S: state,C1: com,C22: com,Cs3: list @ com] :
      ( ~ ( B2 @ S )
     => ( member @ ( product_prod @ ( product_prod @ ( list @ com ) @ state ) @ ( product_prod @ ( list @ com ) @ state ) ) @ ( product_Pair @ ( product_prod @ ( list @ com ) @ state ) @ ( product_prod @ ( list @ com ) @ state ) @ ( product_Pair @ ( list @ com ) @ state @ ( cons @ com @ ( cond @ B2 @ C1 @ C22 ) @ Cs3 ) @ S ) @ ( product_Pair @ ( list @ com ) @ state @ ( cons @ com @ C22 @ Cs3 ) @ S ) ) @ pHoare1053570893_exec1 ) ) ).

% exec1.IfFalse
thf(fact_154_exec1_OIfTrue,axiom,
    ! [B2: state > $o,S: state,C1: com,C22: com,Cs3: list @ com] :
      ( ( B2 @ S )
     => ( member @ ( product_prod @ ( product_prod @ ( list @ com ) @ state ) @ ( product_prod @ ( list @ com ) @ state ) ) @ ( product_Pair @ ( product_prod @ ( list @ com ) @ state ) @ ( product_prod @ ( list @ com ) @ state ) @ ( product_Pair @ ( list @ com ) @ state @ ( cons @ com @ ( cond @ B2 @ C1 @ C22 ) @ Cs3 ) @ S ) @ ( product_Pair @ ( list @ com ) @ state @ ( cons @ com @ C1 @ Cs3 ) @ S ) ) @ pHoare1053570893_exec1 ) ) ).

% exec1.IfTrue
thf(fact_155_gen__length__code_I2_J,axiom,
    ! [B: $tType,N: nat,X: B,Xs: list @ B] :
      ( ( gen_length @ B @ N @ ( cons @ B @ X @ Xs ) )
      = ( gen_length @ B @ ( suc @ N ) @ Xs ) ) ).

% gen_length_code(2)
thf(fact_156_insert__Nil,axiom,
    ! [A: $tType,X: A] :
      ( ( insert @ A @ X @ ( nil @ A ) )
      = ( cons @ A @ X @ ( nil @ A ) ) ) ).

% insert_Nil
thf(fact_157_exec1_OWhileFalse,axiom,
    ! [B2: state > $o,S: state,C: com,Cs3: list @ com] :
      ( ~ ( B2 @ S )
     => ( member @ ( product_prod @ ( product_prod @ ( list @ com ) @ state ) @ ( product_prod @ ( list @ com ) @ state ) ) @ ( product_Pair @ ( product_prod @ ( list @ com ) @ state ) @ ( product_prod @ ( list @ com ) @ state ) @ ( product_Pair @ ( list @ com ) @ state @ ( cons @ com @ ( while @ B2 @ C ) @ Cs3 ) @ S ) @ ( product_Pair @ ( list @ com ) @ state @ Cs3 @ S ) ) @ pHoare1053570893_exec1 ) ) ).

% exec1.WhileFalse
thf(fact_158_com_Oinject_I4_J,axiom,
    ! [X41: state > $o,X42: com,Y41: state > $o,Y42: com] :
      ( ( ( while @ X41 @ X42 )
        = ( while @ Y41 @ Y42 ) )
      = ( ( X41 = Y41 )
        & ( X42 = Y42 ) ) ) ).

% com.inject(4)
thf(fact_159_com_Odistinct_I19_J,axiom,
    ! [X31: state > $o,X322: com,X33: com,X41: state > $o,X42: com] :
      ( ( cond @ X31 @ X322 @ X33 )
     != ( while @ X41 @ X42 ) ) ).

% com.distinct(19)
thf(fact_160_while__termiE,axiom,
    ! [B2: state > $o,C: com,S: state] :
      ( ( termi @ ( while @ B2 @ C ) @ S )
     => ( ( B2 @ S )
       => ( termi @ C @ S ) ) ) ).

% while_termiE
thf(fact_161_exec_OWhileFalse,axiom,
    ! [B2: state > $o,S: state,C: com] :
      ( ~ ( B2 @ S )
     => ( exec @ S @ ( while @ B2 @ C ) @ S ) ) ).

% exec.WhileFalse
thf(fact_162_exec_OWhileTrue,axiom,
    ! [B2: state > $o,S: state,C: com,T2: state,U: state] :
      ( ( B2 @ S )
     => ( ( exec @ S @ C @ T2 )
       => ( ( exec @ T2 @ ( while @ B2 @ C ) @ U )
         => ( exec @ S @ ( while @ B2 @ C ) @ U ) ) ) ) ).

% exec.WhileTrue
thf(fact_163_termi_OWhileFalse,axiom,
    ! [B2: state > $o,S: state,C: com] :
      ( ~ ( B2 @ S )
     => ( termi @ ( while @ B2 @ C ) @ S ) ) ).

% termi.WhileFalse
thf(fact_164_com_Odistinct_I5_J,axiom,
    ! [X1: state > ( set @ state ),X41: state > $o,X42: com] :
      ( ( do @ X1 )
     != ( while @ X41 @ X42 ) ) ).

% com.distinct(5)
thf(fact_165_com_Odistinct_I13_J,axiom,
    ! [X21: com,X22: com,X41: state > $o,X42: com] :
      ( ( semi @ X21 @ X22 )
     != ( while @ X41 @ X42 ) ) ).

% com.distinct(13)
thf(fact_166_termi_OWhileTrue,axiom,
    ! [B2: state > $o,S: state,C: com] :
      ( ( B2 @ S )
     => ( ( termi @ C @ S )
       => ( ! [T3: state] :
              ( ( exec @ S @ C @ T3 )
             => ( termi @ ( while @ B2 @ C ) @ T3 ) )
         => ( termi @ ( while @ B2 @ C ) @ S ) ) ) ) ).

% termi.WhileTrue
thf(fact_167_while__termiE2,axiom,
    ! [B2: state > $o,C: com,S: state,T2: state] :
      ( ( termi @ ( while @ B2 @ C ) @ S )
     => ( ( B2 @ S )
       => ( ( exec @ S @ C @ T2 )
         => ( termi @ ( while @ B2 @ C ) @ T2 ) ) ) ) ).

% while_termiE2
thf(fact_168_gen__length__code_I1_J,axiom,
    ! [A: $tType,N: nat] :
      ( ( gen_length @ A @ N @ ( nil @ A ) )
      = N ) ).

% gen_length_code(1)
thf(fact_169_termi__while,axiom,
    ! [B2: state > $o,C: com,F: nat > state,K: nat] :
      ( ( termi @ ( while @ B2 @ C ) @ ( F @ K ) )
     => ( ! [I: nat] : ( exec @ ( F @ I ) @ C @ ( F @ ( suc @ I ) ) )
       => ? [I: nat] :
            ~ ( B2 @ ( F @ I ) ) ) ) ).

% termi_while
thf(fact_170_termi__while__lemma,axiom,
    ! [W: com,Fk: state,F: nat > state,K: nat,B2: state > $o,C: com] :
      ( ( termi @ W @ Fk )
     => ( ( ( Fk
            = ( F @ K ) )
          & ( W
            = ( while @ B2 @ C ) )
          & ! [I: nat] : ( exec @ ( F @ I ) @ C @ ( F @ ( suc @ I ) ) ) )
       => ? [I: nat] :
            ~ ( B2 @ ( F @ I ) ) ) ) ).

% termi_while_lemma
thf(fact_171_exec1E_I5_J,axiom,
    ! [B2: state > $o,C: com,Cs3: list @ com,S: state,Cs: list @ com,S2: state] :
      ( ( member @ ( product_prod @ ( product_prod @ ( list @ com ) @ state ) @ ( product_prod @ ( list @ com ) @ state ) ) @ ( product_Pair @ ( product_prod @ ( list @ com ) @ state ) @ ( product_prod @ ( list @ com ) @ state ) @ ( product_Pair @ ( list @ com ) @ state @ ( cons @ com @ ( while @ B2 @ C ) @ Cs3 ) @ S ) @ ( product_Pair @ ( list @ com ) @ state @ Cs @ S2 ) ) @ pHoare1053570893_exec1 )
     => ( ( ( Cs = Cs3 )
         => ( ( S2 = S )
           => ( B2 @ S ) ) )
       => ~ ( ( Cs
              = ( cons @ com @ C @ ( cons @ com @ ( while @ B2 @ C ) @ Cs3 ) ) )
           => ( ( S2 = S )
             => ~ ( B2 @ S ) ) ) ) ) ).

% exec1E(5)
thf(fact_172_exec1_OWhileTrue,axiom,
    ! [B2: state > $o,S: state,C: com,Cs3: list @ com] :
      ( ( B2 @ S )
     => ( member @ ( product_prod @ ( product_prod @ ( list @ com ) @ state ) @ ( product_prod @ ( list @ com ) @ state ) ) @ ( product_Pair @ ( product_prod @ ( list @ com ) @ state ) @ ( product_prod @ ( list @ com ) @ state ) @ ( product_Pair @ ( list @ com ) @ state @ ( cons @ com @ ( while @ B2 @ C ) @ Cs3 ) @ S ) @ ( product_Pair @ ( list @ com ) @ state @ ( cons @ com @ C @ ( cons @ com @ ( while @ B2 @ C ) @ Cs3 ) ) @ S ) ) @ pHoare1053570893_exec1 ) ) ).

% exec1.WhileTrue
thf(fact_173_nths__singleton,axiom,
    ! [A: $tType,A5: set @ nat,X: A] :
      ( ( ( member @ nat @ ( zero_zero @ nat ) @ A5 )
       => ( ( nths @ A @ ( cons @ A @ X @ ( nil @ A ) ) @ A5 )
          = ( cons @ A @ X @ ( nil @ A ) ) ) )
      & ( ~ ( member @ nat @ ( zero_zero @ nat ) @ A5 )
       => ( ( nths @ A @ ( cons @ A @ X @ ( nil @ A ) ) @ A5 )
          = ( nil @ A ) ) ) ) ).

% nths_singleton
thf(fact_174_app__execs,axiom,
    ! [Cs3: list @ com,S: state,Cs: list @ com,S2: state,Cs22: list @ com] :
      ( ( member @ ( product_prod @ ( product_prod @ ( list @ com ) @ state ) @ ( product_prod @ ( list @ com ) @ state ) ) @ ( product_Pair @ ( product_prod @ ( list @ com ) @ state ) @ ( product_prod @ ( list @ com ) @ state ) @ ( product_Pair @ ( list @ com ) @ state @ Cs3 @ S ) @ ( product_Pair @ ( list @ com ) @ state @ Cs @ S2 ) ) @ ( transitive_rtrancl @ ( product_prod @ ( list @ com ) @ state ) @ pHoare1053570893_exec1 ) )
     => ( member @ ( product_prod @ ( product_prod @ ( list @ com ) @ state ) @ ( product_prod @ ( list @ com ) @ state ) ) @ ( product_Pair @ ( product_prod @ ( list @ com ) @ state ) @ ( product_prod @ ( list @ com ) @ state ) @ ( product_Pair @ ( list @ com ) @ state @ ( append @ com @ Cs3 @ Cs22 ) @ S ) @ ( product_Pair @ ( list @ com ) @ state @ ( append @ com @ Cs @ Cs22 ) @ S2 ) ) @ ( transitive_rtrancl @ ( product_prod @ ( list @ com ) @ state ) @ pHoare1053570893_exec1 ) ) ) ).

% app_execs
thf(fact_175_listrel_Ocases,axiom,
    ! [B: $tType,A: $tType,A1: list @ A,A22: list @ B,R: set @ ( product_prod @ A @ B )] :
      ( ( member @ ( product_prod @ ( list @ A ) @ ( list @ B ) ) @ ( product_Pair @ ( list @ A ) @ ( list @ B ) @ A1 @ A22 ) @ ( listrel @ A @ B @ R ) )
     => ( ( ( A1
            = ( nil @ A ) )
         => ( A22
           != ( nil @ B ) ) )
       => ~ ! [X3: A,Y2: B,Xs2: list @ A] :
              ( ( A1
                = ( cons @ A @ X3 @ Xs2 ) )
             => ! [Ys3: list @ B] :
                  ( ( A22
                    = ( cons @ B @ Y2 @ Ys3 ) )
                 => ( ( member @ ( product_prod @ A @ B ) @ ( product_Pair @ A @ B @ X3 @ Y2 ) @ R )
                   => ~ ( member @ ( product_prod @ ( list @ A ) @ ( list @ B ) ) @ ( product_Pair @ ( list @ A ) @ ( list @ B ) @ Xs2 @ Ys3 ) @ ( listrel @ A @ B @ R ) ) ) ) ) ) ) ).

% listrel.cases
thf(fact_176_same__append__eq,axiom,
    ! [A: $tType,Xs: list @ A,Ys2: list @ A,Zs2: list @ A] :
      ( ( ( append @ A @ Xs @ Ys2 )
        = ( append @ A @ Xs @ Zs2 ) )
      = ( Ys2 = Zs2 ) ) ).

% same_append_eq
thf(fact_177_append__same__eq,axiom,
    ! [A: $tType,Ys2: list @ A,Xs: list @ A,Zs2: list @ A] :
      ( ( ( append @ A @ Ys2 @ Xs )
        = ( append @ A @ Zs2 @ Xs ) )
      = ( Ys2 = Zs2 ) ) ).

% append_same_eq
thf(fact_178_append__assoc,axiom,
    ! [A: $tType,Xs: list @ A,Ys2: list @ A,Zs2: list @ A] :
      ( ( append @ A @ ( append @ A @ Xs @ Ys2 ) @ Zs2 )
      = ( append @ A @ Xs @ ( append @ A @ Ys2 @ Zs2 ) ) ) ).

% append_assoc
thf(fact_179_append_Oassoc,axiom,
    ! [A: $tType,A2: list @ A,B2: list @ A,C: list @ A] :
      ( ( append @ A @ ( append @ A @ A2 @ B2 ) @ C )
      = ( append @ A @ A2 @ ( append @ A @ B2 @ C ) ) ) ).

% append.assoc
thf(fact_180_append__Nil2,axiom,
    ! [A: $tType,Xs: list @ A] :
      ( ( append @ A @ Xs @ ( nil @ A ) )
      = Xs ) ).

% append_Nil2
thf(fact_181_append__self__conv,axiom,
    ! [A: $tType,Xs: list @ A,Ys2: list @ A] :
      ( ( ( append @ A @ Xs @ Ys2 )
        = Xs )
      = ( Ys2
        = ( nil @ A ) ) ) ).

% append_self_conv
thf(fact_182_self__append__conv,axiom,
    ! [A: $tType,Xs: list @ A,Ys2: list @ A] :
      ( ( Xs
        = ( append @ A @ Xs @ Ys2 ) )
      = ( Ys2
        = ( nil @ A ) ) ) ).

% self_append_conv
thf(fact_183_append__self__conv2,axiom,
    ! [A: $tType,Xs: list @ A,Ys2: list @ A] :
      ( ( ( append @ A @ Xs @ Ys2 )
        = Ys2 )
      = ( Xs
        = ( nil @ A ) ) ) ).

% append_self_conv2
thf(fact_184_self__append__conv2,axiom,
    ! [A: $tType,Ys2: list @ A,Xs: list @ A] :
      ( ( Ys2
        = ( append @ A @ Xs @ Ys2 ) )
      = ( Xs
        = ( nil @ A ) ) ) ).

% self_append_conv2
thf(fact_185_Nil__is__append__conv,axiom,
    ! [A: $tType,Xs: list @ A,Ys2: list @ A] :
      ( ( ( nil @ A )
        = ( append @ A @ Xs @ Ys2 ) )
      = ( ( Xs
          = ( nil @ A ) )
        & ( Ys2
          = ( nil @ A ) ) ) ) ).

% Nil_is_append_conv
thf(fact_186_append__is__Nil__conv,axiom,
    ! [A: $tType,Xs: list @ A,Ys2: list @ A] :
      ( ( ( append @ A @ Xs @ Ys2 )
        = ( nil @ A ) )
      = ( ( Xs
          = ( nil @ A ) )
        & ( Ys2
          = ( nil @ A ) ) ) ) ).

% append_is_Nil_conv
thf(fact_187_append_Oright__neutral,axiom,
    ! [A: $tType,A2: list @ A] :
      ( ( append @ A @ A2 @ ( nil @ A ) )
      = A2 ) ).

% append.right_neutral
thf(fact_188_nths__nil,axiom,
    ! [A: $tType,A5: set @ nat] :
      ( ( nths @ A @ ( nil @ A ) @ A5 )
      = ( nil @ A ) ) ).

% nths_nil
thf(fact_189_append1__eq__conv,axiom,
    ! [A: $tType,Xs: list @ A,X: A,Ys2: list @ A,Y: A] :
      ( ( ( append @ A @ Xs @ ( cons @ A @ X @ ( nil @ A ) ) )
        = ( append @ A @ Ys2 @ ( cons @ A @ Y @ ( nil @ A ) ) ) )
      = ( ( Xs = Ys2 )
        & ( X = Y ) ) ) ).

% append1_eq_conv
thf(fact_190_listrel__rtrancl__refl,axiom,
    ! [A: $tType,Xs: list @ A,R: set @ ( product_prod @ A @ A )] : ( member @ ( product_prod @ ( list @ A ) @ ( list @ A ) ) @ ( product_Pair @ ( list @ A ) @ ( list @ A ) @ Xs @ Xs ) @ ( listrel @ A @ A @ ( transitive_rtrancl @ A @ R ) ) ) ).

% listrel_rtrancl_refl
thf(fact_191_append__eq__append__conv2,axiom,
    ! [A: $tType,Xs: list @ A,Ys2: list @ A,Zs2: list @ A,Ts: list @ A] :
      ( ( ( append @ A @ Xs @ Ys2 )
        = ( append @ A @ Zs2 @ Ts ) )
      = ( ? [Us: list @ A] :
            ( ( ( Xs
                = ( append @ A @ Zs2 @ Us ) )
              & ( ( append @ A @ Us @ Ys2 )
                = Ts ) )
            | ( ( ( append @ A @ Xs @ Us )
                = Zs2 )
              & ( Ys2
                = ( append @ A @ Us @ Ts ) ) ) ) ) ) ).

% append_eq_append_conv2
thf(fact_192_append__eq__appendI,axiom,
    ! [A: $tType,Xs: list @ A,Xs1: list @ A,Zs2: list @ A,Ys2: list @ A,Us2: list @ A] :
      ( ( ( append @ A @ Xs @ Xs1 )
        = Zs2 )
     => ( ( Ys2
          = ( append @ A @ Xs1 @ Us2 ) )
       => ( ( append @ A @ Xs @ Ys2 )
          = ( append @ A @ Zs2 @ Us2 ) ) ) ) ).

% append_eq_appendI
thf(fact_193_eq__Nil__appendI,axiom,
    ! [A: $tType,Xs: list @ A,Ys2: list @ A] :
      ( ( Xs = Ys2 )
     => ( Xs
        = ( append @ A @ ( nil @ A ) @ Ys2 ) ) ) ).

% eq_Nil_appendI
thf(fact_194_append__Nil,axiom,
    ! [A: $tType,Ys2: list @ A] :
      ( ( append @ A @ ( nil @ A ) @ Ys2 )
      = Ys2 ) ).

% append_Nil
thf(fact_195_append_Oleft__neutral,axiom,
    ! [A: $tType,A2: list @ A] :
      ( ( append @ A @ ( nil @ A ) @ A2 )
      = A2 ) ).

% append.left_neutral
thf(fact_196_Cons__eq__appendI,axiom,
    ! [A: $tType,X: A,Xs1: list @ A,Ys2: list @ A,Xs: list @ A,Zs2: list @ A] :
      ( ( ( cons @ A @ X @ Xs1 )
        = Ys2 )
     => ( ( Xs
          = ( append @ A @ Xs1 @ Zs2 ) )
       => ( ( cons @ A @ X @ Xs )
          = ( append @ A @ Ys2 @ Zs2 ) ) ) ) ).

% Cons_eq_appendI
thf(fact_197_append__Cons,axiom,
    ! [A: $tType,X: A,Xs: list @ A,Ys2: list @ A] :
      ( ( append @ A @ ( cons @ A @ X @ Xs ) @ Ys2 )
      = ( cons @ A @ X @ ( append @ A @ Xs @ Ys2 ) ) ) ).

% append_Cons
thf(fact_198_rev__nonempty__induct,axiom,
    ! [A: $tType,Xs: list @ A,P: ( list @ A ) > $o] :
      ( ( Xs
       != ( nil @ A ) )
     => ( ! [X3: A] : ( P @ ( cons @ A @ X3 @ ( nil @ A ) ) )
       => ( ! [X3: A,Xs2: list @ A] :
              ( ( Xs2
               != ( nil @ A ) )
             => ( ( P @ Xs2 )
               => ( P @ ( append @ A @ Xs2 @ ( cons @ A @ X3 @ ( nil @ A ) ) ) ) ) )
         => ( P @ Xs ) ) ) ) ).

% rev_nonempty_induct
thf(fact_199_append__eq__Cons__conv,axiom,
    ! [A: $tType,Ys2: list @ A,Zs2: list @ A,X: A,Xs: list @ A] :
      ( ( ( append @ A @ Ys2 @ Zs2 )
        = ( cons @ A @ X @ Xs ) )
      = ( ( ( Ys2
            = ( nil @ A ) )
          & ( Zs2
            = ( cons @ A @ X @ Xs ) ) )
        | ? [Ys4: list @ A] :
            ( ( Ys2
              = ( cons @ A @ X @ Ys4 ) )
            & ( ( append @ A @ Ys4 @ Zs2 )
              = Xs ) ) ) ) ).

% append_eq_Cons_conv
thf(fact_200_Cons__eq__append__conv,axiom,
    ! [A: $tType,X: A,Xs: list @ A,Ys2: list @ A,Zs2: list @ A] :
      ( ( ( cons @ A @ X @ Xs )
        = ( append @ A @ Ys2 @ Zs2 ) )
      = ( ( ( Ys2
            = ( nil @ A ) )
          & ( ( cons @ A @ X @ Xs )
            = Zs2 ) )
        | ? [Ys4: list @ A] :
            ( ( ( cons @ A @ X @ Ys4 )
              = Ys2 )
            & ( Xs
              = ( append @ A @ Ys4 @ Zs2 ) ) ) ) ) ).

% Cons_eq_append_conv
thf(fact_201_rev__exhaust,axiom,
    ! [A: $tType,Xs: list @ A] :
      ( ( Xs
       != ( nil @ A ) )
     => ~ ! [Ys3: list @ A,Y2: A] :
            ( Xs
           != ( append @ A @ Ys3 @ ( cons @ A @ Y2 @ ( nil @ A ) ) ) ) ) ).

% rev_exhaust
thf(fact_202_rev__induct,axiom,
    ! [A: $tType,P: ( list @ A ) > $o,Xs: list @ A] :
      ( ( P @ ( nil @ A ) )
     => ( ! [X3: A,Xs2: list @ A] :
            ( ( P @ Xs2 )
           => ( P @ ( append @ A @ Xs2 @ ( cons @ A @ X3 @ ( nil @ A ) ) ) ) )
       => ( P @ Xs ) ) ) ).

% rev_induct
thf(fact_203_listrel_ONil,axiom,
    ! [B: $tType,A: $tType,R: set @ ( product_prod @ A @ B )] : ( member @ ( product_prod @ ( list @ A ) @ ( list @ B ) ) @ ( product_Pair @ ( list @ A ) @ ( list @ B ) @ ( nil @ A ) @ ( nil @ B ) ) @ ( listrel @ A @ B @ R ) ) ).

% listrel.Nil
thf(fact_204_listrel__Nil1,axiom,
    ! [A: $tType,B: $tType,Xs: list @ B,R: set @ ( product_prod @ A @ B )] :
      ( ( member @ ( product_prod @ ( list @ A ) @ ( list @ B ) ) @ ( product_Pair @ ( list @ A ) @ ( list @ B ) @ ( nil @ A ) @ Xs ) @ ( listrel @ A @ B @ R ) )
     => ( Xs
        = ( nil @ B ) ) ) ).

% listrel_Nil1
thf(fact_205_listrel__Nil2,axiom,
    ! [B: $tType,A: $tType,Xs: list @ A,R: set @ ( product_prod @ A @ B )] :
      ( ( member @ ( product_prod @ ( list @ A ) @ ( list @ B ) ) @ ( product_Pair @ ( list @ A ) @ ( list @ B ) @ Xs @ ( nil @ B ) ) @ ( listrel @ A @ B @ R ) )
     => ( Xs
        = ( nil @ A ) ) ) ).

% listrel_Nil2
thf(fact_206_listrel__rtrancl__trans,axiom,
    ! [A: $tType,Xs: list @ A,Ys2: list @ A,R: set @ ( product_prod @ A @ A ),Zs2: list @ A] :
      ( ( member @ ( product_prod @ ( list @ A ) @ ( list @ A ) ) @ ( product_Pair @ ( list @ A ) @ ( list @ A ) @ Xs @ Ys2 ) @ ( listrel @ A @ A @ ( transitive_rtrancl @ A @ R ) ) )
     => ( ( member @ ( product_prod @ ( list @ A ) @ ( list @ A ) ) @ ( product_Pair @ ( list @ A ) @ ( list @ A ) @ Ys2 @ Zs2 ) @ ( listrel @ A @ A @ ( transitive_rtrancl @ A @ R ) ) )
       => ( member @ ( product_prod @ ( list @ A ) @ ( list @ A ) ) @ ( product_Pair @ ( list @ A ) @ ( list @ A ) @ Xs @ Zs2 ) @ ( listrel @ A @ A @ ( transitive_rtrancl @ A @ R ) ) ) ) ) ).

% listrel_rtrancl_trans
thf(fact_207_app__exec,axiom,
    ! [Cs3: list @ com,S: state,Cs: list @ com,S2: state,Cs22: list @ com] :
      ( ( member @ ( product_prod @ ( product_prod @ ( list @ com ) @ state ) @ ( product_prod @ ( list @ com ) @ state ) ) @ ( product_Pair @ ( product_prod @ ( list @ com ) @ state ) @ ( product_prod @ ( list @ com ) @ state ) @ ( product_Pair @ ( list @ com ) @ state @ Cs3 @ S ) @ ( product_Pair @ ( list @ com ) @ state @ Cs @ S2 ) ) @ pHoare1053570893_exec1 )
     => ( member @ ( product_prod @ ( product_prod @ ( list @ com ) @ state ) @ ( product_prod @ ( list @ com ) @ state ) ) @ ( product_Pair @ ( product_prod @ ( list @ com ) @ state ) @ ( product_prod @ ( list @ com ) @ state ) @ ( product_Pair @ ( list @ com ) @ state @ ( append @ com @ Cs3 @ Cs22 ) @ S ) @ ( product_Pair @ ( list @ com ) @ state @ ( append @ com @ Cs @ Cs22 ) @ S2 ) ) @ pHoare1053570893_exec1 ) ) ).

% app_exec
thf(fact_208_listrel__Cons2,axiom,
    ! [B: $tType,A: $tType,Xs: list @ A,Y: B,Ys2: list @ B,R: set @ ( product_prod @ A @ B )] :
      ( ( member @ ( product_prod @ ( list @ A ) @ ( list @ B ) ) @ ( product_Pair @ ( list @ A ) @ ( list @ B ) @ Xs @ ( cons @ B @ Y @ Ys2 ) ) @ ( listrel @ A @ B @ R ) )
     => ~ ! [X3: A,Xs2: list @ A] :
            ( ( Xs
              = ( cons @ A @ X3 @ Xs2 ) )
           => ( ( member @ ( product_prod @ A @ B ) @ ( product_Pair @ A @ B @ X3 @ Y ) @ R )
             => ~ ( member @ ( product_prod @ ( list @ A ) @ ( list @ B ) ) @ ( product_Pair @ ( list @ A ) @ ( list @ B ) @ Xs2 @ Ys2 ) @ ( listrel @ A @ B @ R ) ) ) ) ) ).

% listrel_Cons2
thf(fact_209_listrel__Cons1,axiom,
    ! [B: $tType,A: $tType,Y: A,Ys2: list @ A,Xs: list @ B,R: set @ ( product_prod @ A @ B )] :
      ( ( member @ ( product_prod @ ( list @ A ) @ ( list @ B ) ) @ ( product_Pair @ ( list @ A ) @ ( list @ B ) @ ( cons @ A @ Y @ Ys2 ) @ Xs ) @ ( listrel @ A @ B @ R ) )
     => ~ ! [Y2: B,Ys3: list @ B] :
            ( ( Xs
              = ( cons @ B @ Y2 @ Ys3 ) )
           => ( ( member @ ( product_prod @ A @ B ) @ ( product_Pair @ A @ B @ Y @ Y2 ) @ R )
             => ~ ( member @ ( product_prod @ ( list @ A ) @ ( list @ B ) ) @ ( product_Pair @ ( list @ A ) @ ( list @ B ) @ Ys2 @ Ys3 ) @ ( listrel @ A @ B @ R ) ) ) ) ) ).

% listrel_Cons1
thf(fact_210_listrel_OCons,axiom,
    ! [B: $tType,A: $tType,X: A,Y: B,R: set @ ( product_prod @ A @ B ),Xs: list @ A,Ys2: list @ B] :
      ( ( member @ ( product_prod @ A @ B ) @ ( product_Pair @ A @ B @ X @ Y ) @ R )
     => ( ( member @ ( product_prod @ ( list @ A ) @ ( list @ B ) ) @ ( product_Pair @ ( list @ A ) @ ( list @ B ) @ Xs @ Ys2 ) @ ( listrel @ A @ B @ R ) )
       => ( member @ ( product_prod @ ( list @ A ) @ ( list @ B ) ) @ ( product_Pair @ ( list @ A ) @ ( list @ B ) @ ( cons @ A @ X @ Xs ) @ ( cons @ B @ Y @ Ys2 ) ) @ ( listrel @ A @ B @ R ) ) ) ) ).

% listrel.Cons
thf(fact_211_exec1__only1__aux,axiom,
    ! [Ccs: list @ com,S: state,Cs: list @ com,T2: state] :
      ( ( member @ ( product_prod @ ( product_prod @ ( list @ com ) @ state ) @ ( product_prod @ ( list @ com ) @ state ) ) @ ( product_Pair @ ( product_prod @ ( list @ com ) @ state ) @ ( product_prod @ ( list @ com ) @ state ) @ ( product_Pair @ ( list @ com ) @ state @ Ccs @ S ) @ ( product_Pair @ ( list @ com ) @ state @ Cs @ T2 ) ) @ pHoare1053570893_exec1 )
     => ! [C6: com,Cs5: list @ com] :
          ( ( Ccs
            = ( cons @ com @ C6 @ Cs5 ) )
         => ? [Cs1: list @ com] :
              ( Cs
              = ( append @ com @ Cs1 @ Cs5 ) ) ) ) ).

% exec1_only1_aux
thf(fact_212_exec1__only1,axiom,
    ! [C: com,Cs3: list @ com,S: state,Cs: list @ com,T2: state] :
      ( ( member @ ( product_prod @ ( product_prod @ ( list @ com ) @ state ) @ ( product_prod @ ( list @ com ) @ state ) ) @ ( product_Pair @ ( product_prod @ ( list @ com ) @ state ) @ ( product_prod @ ( list @ com ) @ state ) @ ( product_Pair @ ( list @ com ) @ state @ ( cons @ com @ C @ Cs3 ) @ S ) @ ( product_Pair @ ( list @ com ) @ state @ Cs @ T2 ) ) @ pHoare1053570893_exec1 )
     => ? [Cs1: list @ com] :
          ( Cs
          = ( append @ com @ Cs1 @ Cs3 ) ) ) ).

% exec1_only1
thf(fact_213_exec1__drop__suffix__aux,axiom,
    ! [Cs12: list @ com,S: state,Cs1_2: list @ com,S2: state] :
      ( ( member @ ( product_prod @ ( product_prod @ ( list @ com ) @ state ) @ ( product_prod @ ( list @ com ) @ state ) ) @ ( product_Pair @ ( product_prod @ ( list @ com ) @ state ) @ ( product_prod @ ( list @ com ) @ state ) @ ( product_Pair @ ( list @ com ) @ state @ Cs12 @ S ) @ ( product_Pair @ ( list @ com ) @ state @ Cs1_2 @ S2 ) ) @ pHoare1053570893_exec1 )
     => ! [Cs13: list @ com,Cs23: list @ com,Cs14: list @ com] :
          ( ( ( Cs12
              = ( append @ com @ Cs13 @ Cs23 ) )
            & ( Cs1_2
              = ( append @ com @ Cs14 @ Cs23 ) )
            & ( Cs13
             != ( nil @ com ) ) )
         => ( member @ ( product_prod @ ( product_prod @ ( list @ com ) @ state ) @ ( product_prod @ ( list @ com ) @ state ) ) @ ( product_Pair @ ( product_prod @ ( list @ com ) @ state ) @ ( product_prod @ ( list @ com ) @ state ) @ ( product_Pair @ ( list @ com ) @ state @ Cs13 @ S ) @ ( product_Pair @ ( list @ com ) @ state @ Cs14 @ S2 ) ) @ pHoare1053570893_exec1 ) ) ) ).

% exec1_drop_suffix_aux
thf(fact_214_exec1__drop__suffix,axiom,
    ! [Cs15: list @ com,Cs22: list @ com,S: state,Cs16: list @ com,S2: state] :
      ( ( member @ ( product_prod @ ( product_prod @ ( list @ com ) @ state ) @ ( product_prod @ ( list @ com ) @ state ) ) @ ( product_Pair @ ( product_prod @ ( list @ com ) @ state ) @ ( product_prod @ ( list @ com ) @ state ) @ ( product_Pair @ ( list @ com ) @ state @ ( append @ com @ Cs15 @ Cs22 ) @ S ) @ ( product_Pair @ ( list @ com ) @ state @ ( append @ com @ Cs16 @ Cs22 ) @ S2 ) ) @ pHoare1053570893_exec1 )
     => ( ( Cs15
         != ( nil @ com ) )
       => ( member @ ( product_prod @ ( product_prod @ ( list @ com ) @ state ) @ ( product_prod @ ( list @ com ) @ state ) ) @ ( product_Pair @ ( product_prod @ ( list @ com ) @ state ) @ ( product_prod @ ( list @ com ) @ state ) @ ( product_Pair @ ( list @ com ) @ state @ Cs15 @ S ) @ ( product_Pair @ ( list @ com ) @ state @ Cs16 @ S2 ) ) @ pHoare1053570893_exec1 ) ) ) ).

% exec1_drop_suffix
thf(fact_215_listrel_Oinducts,axiom,
    ! [A: $tType,B: $tType,X1: list @ A,X2: list @ B,R: set @ ( product_prod @ A @ B ),P: ( list @ A ) > ( list @ B ) > $o] :
      ( ( member @ ( product_prod @ ( list @ A ) @ ( list @ B ) ) @ ( product_Pair @ ( list @ A ) @ ( list @ B ) @ X1 @ X2 ) @ ( listrel @ A @ B @ R ) )
     => ( ( P @ ( nil @ A ) @ ( nil @ B ) )
       => ( ! [X3: A,Y2: B,Xs2: list @ A,Ys3: list @ B] :
              ( ( member @ ( product_prod @ A @ B ) @ ( product_Pair @ A @ B @ X3 @ Y2 ) @ R )
             => ( ( member @ ( product_prod @ ( list @ A ) @ ( list @ B ) ) @ ( product_Pair @ ( list @ A ) @ ( list @ B ) @ Xs2 @ Ys3 ) @ ( listrel @ A @ B @ R ) )
               => ( ( P @ Xs2 @ Ys3 )
                 => ( P @ ( cons @ A @ X3 @ Xs2 ) @ ( cons @ B @ Y2 @ Ys3 ) ) ) ) )
         => ( P @ X1 @ X2 ) ) ) ) ).

% listrel.inducts
thf(fact_216_listrel_Osimps,axiom,
    ! [B: $tType,A: $tType,A1: list @ A,A22: list @ B,R: set @ ( product_prod @ A @ B )] :
      ( ( member @ ( product_prod @ ( list @ A ) @ ( list @ B ) ) @ ( product_Pair @ ( list @ A ) @ ( list @ B ) @ A1 @ A22 ) @ ( listrel @ A @ B @ R ) )
      = ( ( ( A1
            = ( nil @ A ) )
          & ( A22
            = ( nil @ B ) ) )
        | ? [X4: A,Y3: B,Xs3: list @ A,Ys: list @ B] :
            ( ( A1
              = ( cons @ A @ X4 @ Xs3 ) )
            & ( A22
              = ( cons @ B @ Y3 @ Ys ) )
            & ( member @ ( product_prod @ A @ B ) @ ( product_Pair @ A @ B @ X4 @ Y3 ) @ R )
            & ( member @ ( product_prod @ ( list @ A ) @ ( list @ B ) ) @ ( product_Pair @ ( list @ A ) @ ( list @ B ) @ Xs3 @ Ys ) @ ( listrel @ A @ B @ R ) ) ) ) ) ).

% listrel.simps
thf(fact_217_bind__simps_I2_J,axiom,
    ! [A: $tType,B: $tType,X: B,Xs: list @ B,F: B > ( list @ A )] :
      ( ( bind @ B @ A @ ( cons @ B @ X @ Xs ) @ F )
      = ( append @ A @ ( F @ X ) @ ( bind @ B @ A @ Xs @ F ) ) ) ).

% bind_simps(2)
thf(fact_218_snoc__listrel1__snoc__iff,axiom,
    ! [A: $tType,Xs: list @ A,X: A,Ys2: list @ A,Y: A,R: set @ ( product_prod @ A @ A )] :
      ( ( member @ ( product_prod @ ( list @ A ) @ ( list @ A ) ) @ ( product_Pair @ ( list @ A ) @ ( list @ A ) @ ( append @ A @ Xs @ ( cons @ A @ X @ ( nil @ A ) ) ) @ ( append @ A @ Ys2 @ ( cons @ A @ Y @ ( nil @ A ) ) ) ) @ ( listrel1 @ A @ R ) )
      = ( ( ( member @ ( product_prod @ ( list @ A ) @ ( list @ A ) ) @ ( product_Pair @ ( list @ A ) @ ( list @ A ) @ Xs @ Ys2 ) @ ( listrel1 @ A @ R ) )
          & ( X = Y ) )
        | ( ( Xs = Ys2 )
          & ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ X @ Y ) @ R ) ) ) ) ).

% snoc_listrel1_snoc_iff
thf(fact_219_maps__simps_I1_J,axiom,
    ! [A: $tType,B: $tType,F: B > ( list @ A ),X: B,Xs: list @ B] :
      ( ( maps @ B @ A @ F @ ( cons @ B @ X @ Xs ) )
      = ( append @ A @ ( F @ X ) @ ( maps @ B @ A @ F @ Xs ) ) ) ).

% maps_simps(1)
thf(fact_220_bind__simps_I1_J,axiom,
    ! [B: $tType,A: $tType,F: B > ( list @ A )] :
      ( ( bind @ B @ A @ ( nil @ B ) @ F )
      = ( nil @ A ) ) ).

% bind_simps(1)
thf(fact_221_Cons__listrel1__Cons,axiom,
    ! [A: $tType,X: A,Xs: list @ A,Y: A,Ys2: list @ A,R: set @ ( product_prod @ A @ A )] :
      ( ( member @ ( product_prod @ ( list @ A ) @ ( list @ A ) ) @ ( product_Pair @ ( list @ A ) @ ( list @ A ) @ ( cons @ A @ X @ Xs ) @ ( cons @ A @ Y @ Ys2 ) ) @ ( listrel1 @ A @ R ) )
      = ( ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ X @ Y ) @ R )
          & ( Xs = Ys2 ) )
        | ( ( X = Y )
          & ( member @ ( product_prod @ ( list @ A ) @ ( list @ A ) ) @ ( product_Pair @ ( list @ A ) @ ( list @ A ) @ Xs @ Ys2 ) @ ( listrel1 @ A @ R ) ) ) ) ) ).

% Cons_listrel1_Cons
thf(fact_222_rtrancl__listrel1__ConsI1,axiom,
    ! [A: $tType,Xs: list @ A,Ys2: list @ A,R: set @ ( product_prod @ A @ A ),X: A] :
      ( ( member @ ( product_prod @ ( list @ A ) @ ( list @ A ) ) @ ( product_Pair @ ( list @ A ) @ ( list @ A ) @ Xs @ Ys2 ) @ ( transitive_rtrancl @ ( list @ A ) @ ( listrel1 @ A @ R ) ) )
     => ( member @ ( product_prod @ ( list @ A ) @ ( list @ A ) ) @ ( product_Pair @ ( list @ A ) @ ( list @ A ) @ ( cons @ A @ X @ Xs ) @ ( cons @ A @ X @ Ys2 ) ) @ ( transitive_rtrancl @ ( list @ A ) @ ( listrel1 @ A @ R ) ) ) ) ).

% rtrancl_listrel1_ConsI1
thf(fact_223_listrel1I2,axiom,
    ! [A: $tType,Xs: list @ A,Ys2: list @ A,R: set @ ( product_prod @ A @ A ),X: A] :
      ( ( member @ ( product_prod @ ( list @ A ) @ ( list @ A ) ) @ ( product_Pair @ ( list @ A ) @ ( list @ A ) @ Xs @ Ys2 ) @ ( listrel1 @ A @ R ) )
     => ( member @ ( product_prod @ ( list @ A ) @ ( list @ A ) ) @ ( product_Pair @ ( list @ A ) @ ( list @ A ) @ ( cons @ A @ X @ Xs ) @ ( cons @ A @ X @ Ys2 ) ) @ ( listrel1 @ A @ R ) ) ) ).

% listrel1I2
thf(fact_224_not__listrel1__Nil,axiom,
    ! [A: $tType,Xs: list @ A,R: set @ ( product_prod @ A @ A )] :
      ~ ( member @ ( product_prod @ ( list @ A ) @ ( list @ A ) ) @ ( product_Pair @ ( list @ A ) @ ( list @ A ) @ Xs @ ( nil @ A ) ) @ ( listrel1 @ A @ R ) ) ).

% not_listrel1_Nil
thf(fact_225_not__Nil__listrel1,axiom,
    ! [A: $tType,Xs: list @ A,R: set @ ( product_prod @ A @ A )] :
      ~ ( member @ ( product_prod @ ( list @ A ) @ ( list @ A ) ) @ ( product_Pair @ ( list @ A ) @ ( list @ A ) @ ( nil @ A ) @ Xs ) @ ( listrel1 @ A @ R ) ) ).

% not_Nil_listrel1
thf(fact_226_append__listrel1I,axiom,
    ! [A: $tType,Xs: list @ A,Ys2: list @ A,R: set @ ( product_prod @ A @ A ),Us2: list @ A,Vs: list @ A] :
      ( ( ( ( member @ ( product_prod @ ( list @ A ) @ ( list @ A ) ) @ ( product_Pair @ ( list @ A ) @ ( list @ A ) @ Xs @ Ys2 ) @ ( listrel1 @ A @ R ) )
          & ( Us2 = Vs ) )
        | ( ( Xs = Ys2 )
          & ( member @ ( product_prod @ ( list @ A ) @ ( list @ A ) ) @ ( product_Pair @ ( list @ A ) @ ( list @ A ) @ Us2 @ Vs ) @ ( listrel1 @ A @ R ) ) ) )
     => ( member @ ( product_prod @ ( list @ A ) @ ( list @ A ) ) @ ( product_Pair @ ( list @ A ) @ ( list @ A ) @ ( append @ A @ Xs @ Us2 ) @ ( append @ A @ Ys2 @ Vs ) ) @ ( listrel1 @ A @ R ) ) ) ).

% append_listrel1I
thf(fact_227_listrel__rtrancl__eq__rtrancl__listrel1,axiom,
    ! [A: $tType,R: set @ ( product_prod @ A @ A )] :
      ( ( listrel @ A @ A @ ( transitive_rtrancl @ A @ R ) )
      = ( transitive_rtrancl @ ( list @ A ) @ ( listrel1 @ A @ R ) ) ) ).

% listrel_rtrancl_eq_rtrancl_listrel1
thf(fact_228_rtrancl__listrel1__if__listrel,axiom,
    ! [A: $tType,Xs: list @ A,Ys2: list @ A,R: set @ ( product_prod @ A @ A )] :
      ( ( member @ ( product_prod @ ( list @ A ) @ ( list @ A ) ) @ ( product_Pair @ ( list @ A ) @ ( list @ A ) @ Xs @ Ys2 ) @ ( listrel @ A @ A @ R ) )
     => ( member @ ( product_prod @ ( list @ A ) @ ( list @ A ) ) @ ( product_Pair @ ( list @ A ) @ ( list @ A ) @ Xs @ Ys2 ) @ ( transitive_rtrancl @ ( list @ A ) @ ( listrel1 @ A @ R ) ) ) ) ).

% rtrancl_listrel1_if_listrel
thf(fact_229_maps__simps_I2_J,axiom,
    ! [B: $tType,A: $tType,F: B > ( list @ A )] :
      ( ( maps @ B @ A @ F @ ( nil @ B ) )
      = ( nil @ A ) ) ).

% maps_simps(2)
thf(fact_230_listrel1I1,axiom,
    ! [A: $tType,X: A,Y: A,R: set @ ( product_prod @ A @ A ),Xs: list @ A] :
      ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ X @ Y ) @ R )
     => ( member @ ( product_prod @ ( list @ A ) @ ( list @ A ) ) @ ( product_Pair @ ( list @ A ) @ ( list @ A ) @ ( cons @ A @ X @ Xs ) @ ( cons @ A @ Y @ Xs ) ) @ ( listrel1 @ A @ R ) ) ) ).

% listrel1I1
thf(fact_231_Cons__listrel1E1,axiom,
    ! [A: $tType,X: A,Xs: list @ A,Ys2: list @ A,R: set @ ( product_prod @ A @ A )] :
      ( ( member @ ( product_prod @ ( list @ A ) @ ( list @ A ) ) @ ( product_Pair @ ( list @ A ) @ ( list @ A ) @ ( cons @ A @ X @ Xs ) @ Ys2 ) @ ( listrel1 @ A @ R ) )
     => ( ! [Y2: A] :
            ( ( Ys2
              = ( cons @ A @ Y2 @ Xs ) )
           => ~ ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ X @ Y2 ) @ R ) )
       => ~ ! [Zs: list @ A] :
              ( ( Ys2
                = ( cons @ A @ X @ Zs ) )
             => ~ ( member @ ( product_prod @ ( list @ A ) @ ( list @ A ) ) @ ( product_Pair @ ( list @ A ) @ ( list @ A ) @ Xs @ Zs ) @ ( listrel1 @ A @ R ) ) ) ) ) ).

% Cons_listrel1E1
thf(fact_232_Cons__listrel1E2,axiom,
    ! [A: $tType,Xs: list @ A,Y: A,Ys2: list @ A,R: set @ ( product_prod @ A @ A )] :
      ( ( member @ ( product_prod @ ( list @ A ) @ ( list @ A ) ) @ ( product_Pair @ ( list @ A ) @ ( list @ A ) @ Xs @ ( cons @ A @ Y @ Ys2 ) ) @ ( listrel1 @ A @ R ) )
     => ( ! [X3: A] :
            ( ( Xs
              = ( cons @ A @ X3 @ Ys2 ) )
           => ~ ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ X3 @ Y ) @ R ) )
       => ~ ! [Zs: list @ A] :
              ( ( Xs
                = ( cons @ A @ Y @ Zs ) )
             => ~ ( member @ ( product_prod @ ( list @ A ) @ ( list @ A ) ) @ ( product_Pair @ ( list @ A ) @ ( list @ A ) @ Zs @ Ys2 ) @ ( listrel1 @ A @ R ) ) ) ) ) ).

% Cons_listrel1E2
thf(fact_233_listrel__reflcl__if__listrel1,axiom,
    ! [A: $tType,Xs: list @ A,Ys2: list @ A,R: set @ ( product_prod @ A @ A )] :
      ( ( member @ ( product_prod @ ( list @ A ) @ ( list @ A ) ) @ ( product_Pair @ ( list @ A ) @ ( list @ A ) @ Xs @ Ys2 ) @ ( listrel1 @ A @ R ) )
     => ( member @ ( product_prod @ ( list @ A ) @ ( list @ A ) ) @ ( product_Pair @ ( list @ A ) @ ( list @ A ) @ Xs @ Ys2 ) @ ( listrel @ A @ A @ ( transitive_rtrancl @ A @ R ) ) ) ) ).

% listrel_reflcl_if_listrel1
thf(fact_234_listrel1I,axiom,
    ! [A: $tType,X: A,Y: A,R: set @ ( product_prod @ A @ A ),Xs: list @ A,Us2: list @ A,Vs: list @ A,Ys2: list @ A] :
      ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ X @ Y ) @ R )
     => ( ( Xs
          = ( append @ A @ Us2 @ ( cons @ A @ X @ Vs ) ) )
       => ( ( Ys2
            = ( append @ A @ Us2 @ ( cons @ A @ Y @ Vs ) ) )
         => ( member @ ( product_prod @ ( list @ A ) @ ( list @ A ) ) @ ( product_Pair @ ( list @ A ) @ ( list @ A ) @ Xs @ Ys2 ) @ ( listrel1 @ A @ R ) ) ) ) ) ).

% listrel1I
thf(fact_235_listrel1E,axiom,
    ! [A: $tType,Xs: list @ A,Ys2: list @ A,R: set @ ( product_prod @ A @ A )] :
      ( ( member @ ( product_prod @ ( list @ A ) @ ( list @ A ) ) @ ( product_Pair @ ( list @ A ) @ ( list @ A ) @ Xs @ Ys2 ) @ ( listrel1 @ A @ R ) )
     => ~ ! [X3: A,Y2: A] :
            ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ X3 @ Y2 ) @ R )
           => ! [Us3: list @ A,Vs2: list @ A] :
                ( ( Xs
                  = ( append @ A @ Us3 @ ( cons @ A @ X3 @ Vs2 ) ) )
               => ( Ys2
                 != ( append @ A @ Us3 @ ( cons @ A @ Y2 @ Vs2 ) ) ) ) ) ) ).

% listrel1E
thf(fact_236_rtrancl__listrel1__ConsI2,axiom,
    ! [A: $tType,X: A,Y: A,R: set @ ( product_prod @ A @ A ),Xs: list @ A,Ys2: list @ A] :
      ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ X @ Y ) @ ( transitive_rtrancl @ A @ R ) )
     => ( ( member @ ( product_prod @ ( list @ A ) @ ( list @ A ) ) @ ( product_Pair @ ( list @ A ) @ ( list @ A ) @ Xs @ Ys2 ) @ ( transitive_rtrancl @ ( list @ A ) @ ( listrel1 @ A @ R ) ) )
       => ( member @ ( product_prod @ ( list @ A ) @ ( list @ A ) ) @ ( product_Pair @ ( list @ A ) @ ( list @ A ) @ ( cons @ A @ X @ Xs ) @ ( cons @ A @ Y @ Ys2 ) ) @ ( transitive_rtrancl @ ( list @ A ) @ ( listrel1 @ A @ R ) ) ) ) ) ).

% rtrancl_listrel1_ConsI2
thf(fact_237_concat__eq__append__conv,axiom,
    ! [A: $tType,Xss2: list @ ( list @ A ),Ys2: list @ A,Zs2: list @ A] :
      ( ( ( concat @ A @ Xss2 )
        = ( append @ A @ Ys2 @ Zs2 ) )
      = ( ( ( Xss2
            = ( nil @ ( list @ A ) ) )
         => ( ( Ys2
              = ( nil @ A ) )
            & ( Zs2
              = ( nil @ A ) ) ) )
        & ( ( Xss2
           != ( nil @ ( list @ A ) ) )
         => ? [Xss1: list @ ( list @ A ),Xs3: list @ A,Xs4: list @ A,Xss22: list @ ( list @ A )] :
              ( ( Xss2
                = ( append @ ( list @ A ) @ Xss1 @ ( cons @ ( list @ A ) @ ( append @ A @ Xs3 @ Xs4 ) @ Xss22 ) ) )
              & ( Ys2
                = ( append @ A @ ( concat @ A @ Xss1 ) @ Xs3 ) )
              & ( Zs2
                = ( append @ A @ Xs4 @ ( concat @ A @ Xss22 ) ) ) ) ) ) ) ).

% concat_eq_append_conv
thf(fact_238_lexord__append__left__rightI,axiom,
    ! [A: $tType,A2: A,B2: A,R: set @ ( product_prod @ A @ A ),U: list @ A,X: list @ A,Y: list @ A] :
      ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ A2 @ B2 ) @ R )
     => ( member @ ( product_prod @ ( list @ A ) @ ( list @ A ) ) @ ( product_Pair @ ( list @ A ) @ ( list @ A ) @ ( append @ A @ U @ ( cons @ A @ A2 @ X ) ) @ ( append @ A @ U @ ( cons @ A @ B2 @ Y ) ) ) @ ( lexord @ A @ R ) ) ) ).

% lexord_append_left_rightI
thf(fact_239_concat__append,axiom,
    ! [A: $tType,Xs: list @ ( list @ A ),Ys2: list @ ( list @ A )] :
      ( ( concat @ A @ ( append @ ( list @ A ) @ Xs @ Ys2 ) )
      = ( append @ A @ ( concat @ A @ Xs ) @ ( concat @ A @ Ys2 ) ) ) ).

% concat_append
thf(fact_240_lexord__cons__cons,axiom,
    ! [A: $tType,A2: A,X: list @ A,B2: A,Y: list @ A,R: set @ ( product_prod @ A @ A )] :
      ( ( member @ ( product_prod @ ( list @ A ) @ ( list @ A ) ) @ ( product_Pair @ ( list @ A ) @ ( list @ A ) @ ( cons @ A @ A2 @ X ) @ ( cons @ A @ B2 @ Y ) ) @ ( lexord @ A @ R ) )
      = ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ A2 @ B2 ) @ R )
        | ( ( A2 = B2 )
          & ( member @ ( product_prod @ ( list @ A ) @ ( list @ A ) ) @ ( product_Pair @ ( list @ A ) @ ( list @ A ) @ X @ Y ) @ ( lexord @ A @ R ) ) ) ) ) ).

% lexord_cons_cons
thf(fact_241_lexord__Nil__left,axiom,
    ! [A: $tType,Y: list @ A,R: set @ ( product_prod @ A @ A )] :
      ( ( member @ ( product_prod @ ( list @ A ) @ ( list @ A ) ) @ ( product_Pair @ ( list @ A ) @ ( list @ A ) @ ( nil @ A ) @ Y ) @ ( lexord @ A @ R ) )
      = ( ? [A4: A,X4: list @ A] :
            ( Y
            = ( cons @ A @ A4 @ X4 ) ) ) ) ).

% lexord_Nil_left
thf(fact_242_lexord__linear,axiom,
    ! [A: $tType,R: set @ ( product_prod @ A @ A ),X: list @ A,Y: list @ A] :
      ( ! [A3: A,B3: A] :
          ( ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ A3 @ B3 ) @ R )
          | ( A3 = B3 )
          | ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ B3 @ A3 ) @ R ) )
     => ( ( member @ ( product_prod @ ( list @ A ) @ ( list @ A ) ) @ ( product_Pair @ ( list @ A ) @ ( list @ A ) @ X @ Y ) @ ( lexord @ A @ R ) )
        | ( X = Y )
        | ( member @ ( product_prod @ ( list @ A ) @ ( list @ A ) ) @ ( product_Pair @ ( list @ A ) @ ( list @ A ) @ Y @ X ) @ ( lexord @ A @ R ) ) ) ) ).

% lexord_linear
thf(fact_243_lexord__irreflexive,axiom,
    ! [A: $tType,R: set @ ( product_prod @ A @ A ),Xs: list @ A] :
      ( ! [X3: A] :
          ~ ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ X3 @ X3 ) @ R )
     => ~ ( member @ ( product_prod @ ( list @ A ) @ ( list @ A ) ) @ ( product_Pair @ ( list @ A ) @ ( list @ A ) @ Xs @ Xs ) @ ( lexord @ A @ R ) ) ) ).

% lexord_irreflexive
thf(fact_244_concat_Osimps_I1_J,axiom,
    ! [A: $tType] :
      ( ( concat @ A @ ( nil @ ( list @ A ) ) )
      = ( nil @ A ) ) ).

% concat.simps(1)
thf(fact_245_lexord__Nil__right,axiom,
    ! [A: $tType,X: list @ A,R: set @ ( product_prod @ A @ A )] :
      ~ ( member @ ( product_prod @ ( list @ A ) @ ( list @ A ) ) @ ( product_Pair @ ( list @ A ) @ ( list @ A ) @ X @ ( nil @ A ) ) @ ( lexord @ A @ R ) ) ).

% lexord_Nil_right
thf(fact_246_concat_Osimps_I2_J,axiom,
    ! [A: $tType,X: list @ A,Xs: list @ ( list @ A )] :
      ( ( concat @ A @ ( cons @ ( list @ A ) @ X @ Xs ) )
      = ( append @ A @ X @ ( concat @ A @ Xs ) ) ) ).

% concat.simps(2)
thf(fact_247_lexord__append__leftI,axiom,
    ! [A: $tType,U: list @ A,V: list @ A,R: set @ ( product_prod @ A @ A ),X: list @ A] :
      ( ( member @ ( product_prod @ ( list @ A ) @ ( list @ A ) ) @ ( product_Pair @ ( list @ A ) @ ( list @ A ) @ U @ V ) @ ( lexord @ A @ R ) )
     => ( member @ ( product_prod @ ( list @ A ) @ ( list @ A ) ) @ ( product_Pair @ ( list @ A ) @ ( list @ A ) @ ( append @ A @ X @ U ) @ ( append @ A @ X @ V ) ) @ ( lexord @ A @ R ) ) ) ).

% lexord_append_leftI
thf(fact_248_lexord__append__leftD,axiom,
    ! [A: $tType,X: list @ A,U: list @ A,V: list @ A,R: set @ ( product_prod @ A @ A )] :
      ( ( member @ ( product_prod @ ( list @ A ) @ ( list @ A ) ) @ ( product_Pair @ ( list @ A ) @ ( list @ A ) @ ( append @ A @ X @ U ) @ ( append @ A @ X @ V ) ) @ ( lexord @ A @ R ) )
     => ( ! [A3: A] :
            ~ ( member @ ( product_prod @ A @ A ) @ ( product_Pair @ A @ A @ A3 @ A3 ) @ R )
       => ( member @ ( product_prod @ ( list @ A ) @ ( list @ A ) ) @ ( product_Pair @ ( list @ A ) @ ( list @ A ) @ U @ V ) @ ( lexord @ A @ R ) ) ) ) ).

% lexord_append_leftD
thf(fact_249_lexord__append__rightI,axiom,
    ! [A: $tType,Y: list @ A,X: list @ A,R: set @ ( product_prod @ A @ A )] :
      ( ? [B6: A,Z3: list @ A] :
          ( Y
          = ( cons @ A @ B6 @ Z3 ) )
     => ( member @ ( product_prod @ ( list @ A ) @ ( list @ A ) ) @ ( product_Pair @ ( list @ A ) @ ( list @ A ) @ X @ ( append @ A @ X @ Y ) ) @ ( lexord @ A @ R ) ) ) ).

% lexord_append_rightI
thf(fact_250_concat__eq__appendD,axiom,
    ! [A: $tType,Xss2: list @ ( list @ A ),Ys2: list @ A,Zs2: list @ A] :
      ( ( ( concat @ A @ Xss2 )
        = ( append @ A @ Ys2 @ Zs2 ) )
     => ( ( Xss2
         != ( nil @ ( list @ A ) ) )
       => ? [Xss12: list @ ( list @ A ),Xs2: list @ A,Xs5: list @ A,Xss23: list @ ( list @ A )] :
            ( ( Xss2
              = ( append @ ( list @ A ) @ Xss12 @ ( cons @ ( list @ A ) @ ( append @ A @ Xs2 @ Xs5 ) @ Xss23 ) ) )
            & ( Ys2
              = ( append @ A @ ( concat @ A @ Xss12 ) @ Xs2 ) )
            & ( Zs2
              = ( append @ A @ Xs5 @ ( concat @ A @ Xss23 ) ) ) ) ) ) ).

% concat_eq_appendD
thf(fact_251_lexord__same__pref__if__irrefl,axiom,
    ! [A: $tType,R: set @ ( product_prod @ A @ A ),Xs: list @ A,Ys2: list @ A,Zs2: list @ A] :
      ( ( irrefl @ A @ R )
     => ( ( member @ ( product_prod @ ( list @ A ) @ ( list @ A ) ) @ ( product_Pair @ ( list @ A ) @ ( list @ A ) @ ( append @ A @ Xs @ Ys2 ) @ ( append @ A @ Xs @ Zs2 ) ) @ ( lexord @ A @ R ) )
        = ( member @ ( product_prod @ ( list @ A ) @ ( list @ A ) ) @ ( product_Pair @ ( list @ A ) @ ( list @ A ) @ Ys2 @ Zs2 ) @ ( lexord @ A @ R ) ) ) ) ).

% lexord_same_pref_if_irrefl

% Type constructors (7)
thf(tcon_fun___Orderings_Oord,axiom,
    ! [A7: $tType,A8: $tType] :
      ( ( ord @ A8 )
     => ( ord @ ( A7 > A8 ) ) ) ).

thf(tcon_Nat_Onat___Orderings_Olinorder,axiom,
    linorder @ nat ).

thf(tcon_Nat_Onat___Orderings_Oord_1,axiom,
    ord @ nat ).

thf(tcon_Nat_Onat___Groups_Ozero,axiom,
    zero @ nat ).

thf(tcon_Set_Oset___Orderings_Oord_2,axiom,
    ! [A7: $tType] : ( ord @ ( set @ A7 ) ) ).

thf(tcon_HOL_Obool___Orderings_Olinorder_3,axiom,
    linorder @ $o ).

thf(tcon_HOL_Obool___Orderings_Oord_4,axiom,
    ord @ $o ).

% Conjectures (5)
thf(conj_0,hypothesis,
    termi @ c @ s ).

thf(conj_1,hypothesis,
    ( ( f @ ( zero_zero @ nat ) )
    = ( product_Pair @ ( list @ com ) @ state @ ( cons @ com @ c @ ( nil @ com ) ) @ s ) ) ).

thf(conj_2,hypothesis,
    ! [I2: nat] : ( member @ ( product_prod @ ( product_prod @ ( list @ com ) @ state ) @ ( product_prod @ ( list @ com ) @ state ) ) @ ( product_Pair @ ( product_prod @ ( list @ com ) @ state ) @ ( product_prod @ ( list @ com ) @ state ) @ ( f @ I2 ) @ ( f @ ( suc @ I2 ) ) ) @ ( transitive_trancl @ ( product_prod @ ( list @ com ) @ state ) @ pHoare1053570893_exec1 ) ) ).

thf(conj_3,hypothesis,
    member @ ( product_prod @ ( product_prod @ ( list @ com ) @ state ) @ ( product_prod @ ( list @ com ) @ state ) ) @ ( product_Pair @ ( product_prod @ ( list @ com ) @ state ) @ ( product_prod @ ( list @ com ) @ state ) @ ( product_Pair @ ( list @ com ) @ state @ ( cons @ com @ c @ ( nil @ com ) ) @ s ) @ ( f @ n ) ) @ ( transitive_rtrancl @ ( product_prod @ ( list @ com ) @ state ) @ pHoare1053570893_exec1 ) ).

thf(conj_4,conjecture,
    member @ ( product_prod @ ( product_prod @ ( list @ com ) @ state ) @ ( product_prod @ ( list @ com ) @ state ) ) @ ( product_Pair @ ( product_prod @ ( list @ com ) @ state ) @ ( product_prod @ ( list @ com ) @ state ) @ ( product_Pair @ ( list @ com ) @ state @ ( cons @ com @ c @ ( nil @ com ) ) @ s ) @ ( f @ ( suc @ n ) ) ) @ ( transitive_rtrancl @ ( product_prod @ ( list @ com ) @ state ) @ pHoare1053570893_exec1 ) ).

%------------------------------------------------------------------------------
